/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.Language;

import java.util.Enumeration;
import org.omegahat.Environment.Databases.ClosureDatabase;
import org.omegahat.Environment.Databases.Database;
import org.omegahat.Environment.Interpreter.Evaluator;
import org.omegahat.Environment.Language.Function;
import org.omegahat.Environment.Parser.Parse.ExpressionInt;
import org.omegahat.Environment.Parser.Parse.List;
import org.omegahat.Environment.Parser.Parse.LocalVariable;
import org.omegahat.Environment.Parser.Parse.Modifier;
import org.omegahat.Environment.Parser.Parse.Name;

public class Closure
extends Function {
    protected Database staticVariables;
    protected List staticDeclarations;
    protected boolean isInitialized = false;

    public Closure(ExpressionInt expressionInt, List list2, Name name, List list3, String string, Evaluator evaluator) throws ClassNotFoundException {
        super(expressionInt, list2, name, list3, string, evaluator);
        this.findStatics((ExpressionInt)this.body());
    }

    public Object eval(Database database, boolean bl, Evaluator evaluator) throws Throwable {
        if (!this.isInitialized()) {
            this.initializeStatics(evaluator);
        }
        Object object = null;
        evaluator.attach(this.staticVariables, 0);
        try {
            object = super.eval(database, bl, evaluator);
        }
        finally {
            Object var6_5 = null;
            evaluator.detach(this.staticVariables);
        }
        return object;
    }

    public int findStatics(ExpressionInt expressionInt) {
        List list2 = new List();
        if (expressionInt instanceof List) {
            Enumeration enumeration = ((List)expressionInt).elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof LocalVariable) || !this.isStaticVariable((LocalVariable)e)) continue;
                list2.addElement(e);
                ((LocalVariable)e).isActive(false);
            }
        }
        this.staticDeclarations(list2);
        return list2.size();
    }

    public int initializeStatics(Evaluator evaluator) throws Throwable {
        List list2 = this.staticDeclarations();
        if (list2 != null) {
            ClosureDatabase closureDatabase = new ClosureDatabase("Closure statics");
            Enumeration enumeration = list2.elements();
            while (enumeration.hasMoreElements()) {
                LocalVariable localVariable = (LocalVariable)enumeration.nextElement();
                localVariable.isActive(true);
                this.createVariable(localVariable, closureDatabase, evaluator);
                localVariable.isActive(false);
            }
            this.staticVariables(closureDatabase);
        }
        this.isInitialized(true);
        return this.staticVariables().size();
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public boolean isInitialized(boolean bl) {
        this.isInitialized = bl;
        return this.isInitialized();
    }

    protected boolean isStaticVariable(LocalVariable localVariable) {
        Modifier modifier = localVariable.modifiers();
        if (modifier == null) {
            return false;
        }
        return modifier.isStatic();
    }

    public List staticDeclarations() {
        return this.staticDeclarations;
    }

    public List staticDeclarations(List list2) {
        this.staticDeclarations = list2;
        return this.staticDeclarations();
    }

    public Database staticVariables() {
        return this.staticVariables;
    }

    public Database staticVariables(Database database) {
        this.staticVariables = database;
        return this.staticVariables();
    }
}

