% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_samples.R
\name{add_samples}
\alias{add_samples}
\title{Continue sampling from an object of class JointAI}
\usage{
add_samples(
  object,
  n.iter,
  add = TRUE,
  thin = NULL,
  monitor_params = NULL,
  progress.bar = "text",
  mess = TRUE
)
}
\arguments{
\item{object}{object inheriting from class 'JointAI'}

\item{n.iter}{the number of iterations of the MCMC chain (after adaptation;
see also \code{\link[rjags]{coda.samples}})}

\item{add}{logical; should the new MCMC samples be added to the existing
samples or replace them? If samples are added,
\code{var.names} is ignored.}

\item{thin}{thinning interval (see \code{\link[coda]{window.mcmc}})}

\item{monitor_params}{named vector specifying which parameters should be
monitored (see details)}

\item{progress.bar}{character string specifying the type of progress bar.
Possible values are "text", "gui", and "none" (see
\code{\link[rjags]{update}}). Note: when sampling is performed
in parallel it is currently not possible to display a
progress bar.}

\item{mess}{logical; should messages be given? Default is
\code{TRUE}. (Note: this applies only to messages
given directly by \strong{JointAI}.)}
}
\description{
This function allows to continue sampling from an existing object of class 'JointAI'.\cr
If the original sample was created using parallel computation, the
separate 'jags' objects will be recompiled and sampling will again be
performed in parallel.
}
\section{Note}{

When the thinning interval differs between the original model and the added
samples, the resulting, new, 'JointAI' object does not yet record this information.
Moreover, when \code{add_samples()} is used with \code{add = FALSE} the
indices of iterations (for example given in the \code{summary()}) may not be
correct.
}

\examples{
# Example 1:
# Run an initial JointAI model:
mod <- lm_imp(y ~ C1 + C2, data = wideDF, n.iter = 100)

# Continue sampling:
mod_add <- add_samples(mod, n.iter = 200, add = TRUE)


# Example 2:
# Continue sampling, but additionally sample imputed values.
# Note: Setting different parameters to monitor than in the original model
# requires add = FALSE.
imps <- add_samples(mod, n.iter = 200, monitor_params = c("imps" = TRUE),
                    add = FALSE)

}
\seealso{
\code{\link[JointAI:model_imp]{*_imp}}

The vignette \href{https://nerler.github.io/JointAI/articles/SelectingParameters.html}{Parameter Selection}
contains some examples on how to specify the argument \code{monitor_params}.
}
