library(JointNets)

graphics.off()
par(ask = FALSE)
par(mfrow = c(1, 1))


readline(prompt = "Press [enter] to continue to cancer demo with 2 tasks (not v. pcr) and 26 features (26 cancer types) ")

data(cancer)
cancerlist = list(as.matrix(cancer[[1]][which(cancer[[2]] == "not"), ]),
                  as.matrix(cancer[[1]][which(cancer[[2]] == "pcr"), ]))

### group node 1 to 3 to group 1 and node 4 to 6 to group 2, the rest of the nodes are not grouped
### same weights for all edges (W is a matrix of ones)
result = diffeek(cancerlist[[1]], cancerlist[[2]], W = matrix(1,26,26), g = c(rep(1,3),rep(2,3),rep(0,20)),
                 epsilon = 1, lambda = 0.3, covType = "kendall")

label = colnames(cancer[[1]])
graph = returngraph(result)
layout = layout_nicely(graph, dim = 2)

readline(prompt = "Press [enter] to view the difference graph generated by diffeek")

{
  par(mfrow = c(1, 2))
  plot(result, layout = layout)
  nodeid = which(label %in% c("BECNI", "FLJI2650"))
  plot(result,
       type = "neighbour",
       index = nodeid,
       layout = layout)
}

readline(prompt = "Press [enter] to continue to NIPS word count demo with 2 tasks (before 2006 and after 2006) and 37 features (37 words)")


data(nip_37_data)
label = colnames(nip_37_data[[1]])

### no grouping information (g = 0), same weight for all edges (W is a matrix of ones)
result = diffeek(nip_37_data[[1]], nip_37_data[[2]], W = matrix(1,37,37), g = 0,
                 epsilon = 1, lambda = 0.1,covType = "kendall")

graph = returngraph(result)
layout = layout_nicely(graph, dim = 2)

readline(prompt = "Press [enter] to view the difference graph")

{
  par(mfrow = c(1, 2))
  plot(result, layout = layout)
  nodeid = which(label %in% c("results", "section")) ### look for id
  plot(result,
       type = "neighbour",
       index = nodeid,
       layout = layout)
}



readline(prompt = "Press [enter] to continue to synthetic Gaussian data demo with 2 tasks and 20 features")


data(exampleData)
### no grouping information (zero entries for g), same weight for all edges (W is a matrix of ones)
result = diffeek(exampleData[[1]], exampleData[[2]], W = matrix(1,20,20), g = rep(0,20),
                 epsilon = 0.2, lambda = 0.4,covType = "cov")
data(exampleDataGraph)
layout = layout_nicely(exampleDataGraph[[1]], dim = 2)


readline(prompt = "Press [enter] to view comparison between ground truth and generated difference graph")

{
  par(mfrow = c(1, 2))
  plot(result, layout = layout)
  plot(
    union(exampleDataGraph[[2]], exampleDataGraph[[3]]),
    layout = layout,
    vertex.label.font = 2,
    vertex.shape = "none",
    vertex.label.color = "gray40",
    vertex.label.cex = .7,
    vertex.frame.color = "white",
    vertex.size = 10 ,
    edge.color = rainbow(1)[1],
    main = "difference graph ground truth"
  )
}

readline(prompt = "Press [enter] to continue to synthetic Gaussian data demo with 2 tasks and 500 features")


readline(prompt = "Press [enter] to view the DIFFEEK runtime (takes roughly 30 seconds on an i7 machine)")
{
  data500 = simulation(p=500, n = c(500,500))
  start_time = Sys.time()
  diffeek(data500$simulatedsamples[[1]], data500$simulatedsamples[[2]], W = matrix(1,500,500), g = rep(0,500),
                   epsilon = 0.2, lambda = 0.4,covType = "cov")
  end_time = Sys.time()
  print(paste(
    "the time taken for DIFFEEK to run with p = 500 is",
    end_time - start_time,
    "mins"
  ))
}
