% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotbrain.R
\name{plotbrain_joint}
\alias{plotbrain_joint}
\title{plot 3d brain network}
\usage{
plotbrain_joint(x, type = "task", neighbouroption = "task",
  subID = NULL, index = NULL, hastitle = TRUE, haslegend = TRUE,
  hasbackground = TRUE, ...)
}
\arguments{
\item{x}{output generated from JointNets Methods}

\item{type}{type of graph. There are four options:
\itemize{
\item "task" (graph for each task (including shared part) specified further by subID (task number))
\item "share" (shared graph for all tasks)
\item "taskspecific" (graph for each task specific graph (excluding shared part)
specified further by subID (task number) )
\item "neighbour" (zoom into nodes in the graph specified further by neighbouroptoin, subID (task number)
and index (node id))
}}

\item{neighbouroption}{determines what type of graph to zoom into when parameter \strong{"type"} is \strong{"neighbour"}. There are two options:
\itemize{
\item "task" (zoom into graph for each task (including shared part))
\item "taskspecific" (zoom into graph for each task specific (excluding shared part))
}}

\item{subID}{selects which task to display. There are four options:
\itemize{
\item 0 (only allowed when
\strong{"type"} is \strong{"task"} or \strong{"type"} is \strong{"neighbour"} and \strong{"neighbouroption"} is \strong{"task"}) (selects share graph)
\item positive task number (selects that particular task)
\item a vector of task number (selects multiple tasks)
\item NULL (selects all tasks (all graphs))
}}

\item{index}{determines which node(s) to zoom into when parameter \strong{"type"} is \strong{"neighbour"}.
This parameter could either be an integer or vector of integers representing node ids
(zoom into one node or multiple nodes)}

\item{hastitle}{determines whether the graph title is displayed or not (TRUE to display / FALSE to hide)}

\item{haslegend}{determines whether the graph legend is displayed or not (TRUE to display / FALSE to hide)}

\item{hasbackground}{determines whether the reference brain is plotted or not (TRUE to display / FALSE to hide)}

\item{...}{extra parameters passed to igraph::rglplot() and level in misc::contour3d()}
}
\value{
3d (rgl) brain network
}
\description{
plot 3d brain network
}
