% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{juliaPut}
\alias{juliaPut}
\title{Create a Julia proxy object from an R object}
\usage{
juliaPut(x)
}
\arguments{
\item{x}{an R object (can also be a translated Julia object)}
}
\description{
This function creates a proxy object for a Julia object that would
otherwise be translated to an R object.
This is useful to prevent many translations of large objects
if it is necessary performance reasons.
To see which objects are translated by default, please see the
\link{JuliaConnectoR-package} documentation.
}
\examples{
if (juliaSetupOk()) {

   # Transfer a large vector to Julia and use it in multiple calls
   x <- juliaPut(rnorm(100))
   # x is just a reference to a Julia vector now
   juliaEval("using Statistics")
   juliaCall("mean", x)
   juliaCall("var", x)

}

\dontshow{
JuliaConnectoR:::stopJulia()
}
}
