% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rec2Polar.R
\name{Rec2Polar}
\alias{Rec2Polar}
\title{Rectangular to polar coordinates}
\usage{
Rec2Polar(X)
}
\arguments{
\item{X}{A vector in rectangular coordinate. Suppose the dimension of
\code{X} is \code{d}.}
}
\value{
A list of the following:
\item{R}{The length of \code{X}.}
\item{Theta}{A vector of length \code{d-1}, containing the angles of \code{X}.}
}
\description{
Given a \code{d}-dimensional vector \code{X} in rectangular coordinate, this
function compute its polar coordinate \code{(R,Theta)}, where \code{R} is the
length of \code{X} and the \code{(d-1)}-dimensional vector \code{Theta}
contains the \code{d-1} angles of \code{X}.
}
\details{
The formula corresponds to theta=g(v) as in Lemma 1 of Tang and Li (2024).
See also Anderson (2003).
Note that when \code{d=2}, \code{V} will be \code{(sin(Theta),cos(Theta))}.
}
\examples{
X=c(3,1,3)
Rec2Polar(X)

}
\references{
\cite{Tang, Y. and Li, B. (2024), “A nonparametric test for elliptical
distribution based on kernel embedding of probabilities,”
\url{https://arxiv.org/abs/2306.10594}}
\cite{Anderson, T. W. (2003). An Introduction to Multivariate Statistical
Analysis. John Wiley & Suns, Inc. Huboken, New Jersey.}
}
