% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kobt.select.R
\name{kobt.select}
\alias{kobt.select}
\title{Knockoff Variable Selection}
\usage{
kobt.select(score, fdr = 0.1, type = "modified")
}
\arguments{
\item{score}{An n by 2p matrix of test statistics, which includes test statistics from n samples, p variables (first p columns), and p knockoff variables (last p columns).}

\item{fdr}{The targeted false discovery rate (FDR), the default value is 0.1.}

\item{type}{A charactor showing the type of calculated false discovery rate: (1) modified and (2) usual FDR, the default value is modified.}
}
\value{
Indices of selected columns/variables in the n by p original design matrix.
}
\description{
Use knockoff to conduct variable selection with false discovery rarte control.
}
\examples{
set.seed(1010)
n <- 100
p <- 100
signal.num <- 20
W_left <- matrix(rnorm(n = n*signal.num, mean = 1, sd = 1), nrow = n)
W_right <- matrix(rnorm(n = n*(2*p-signal.num), mean = 0, sd = 1), nrow = n)
W <- cbind(W_left, W_right)
selected.index <- kobt.select(score = W)

}
\references{
\insertRef{candes2018panning}{KOBT}
}
