# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Generic weighted p-distance
#' @description Many isotropic models can be defined employing a distance. In particular this 
#' function implements a distance employing weights and different powers.
#' @param x First vector.
#' @param y Second vector.
#' @param w Weights for every coordinate in the vectors.
#' @param p Powers for every coordinate in the vectors. To define a true norm every coordinate
#' has to be greater than 1.
#' @return Real value of the weighted p-distance.
#' @author Pedro Guarderas \email{pedro.felipe.guarderas@@gmail.com}.
#' @examples
#' library(KRIG)
#' 
#' n<-1e5
#' x<-runif( n )
#' y<-runif( n )
#' p<-rep(2.5,n)
#' w<-runif(n)
#' 
#' kw<-weight_pow_dist( x, y, w, p )
#' nw<-sum( w * abs( x - y )^p )
#' 
#' nw == kw
#' @export
weight_pow_dist <- function(x, y, w, p) {
    .Call('_KRIG_weight_pow_dist', PACKAGE = 'KRIG', x, y, w, p)
}

#' @title One coordinate kernel integral.
#' @description This function is part of the routines employed in the sensitivity analysis, takes 
#' the kernel \eqn{k} and for each fixed coordinate in \eqn{x}, the integral in the second 
#' variable \eqn{y}, is computed in the interval \eqn{a} to \eqn{b} by taking \eqn{n} uniform
#' steps.
#' @param Kern Kernel function.
#' @param x Column vector with values for the first coordinate of the kernel.
#' @param a Inferior limit for the integral in y.
#' @param b Superior limit for the integral in y.
#' @param n Number of uniform division to compute the integral.
#' @return Vector with integrals while the x coordinate is fixed.
#' @author Pedro Guarderas \email{pedro.felipe.guarderas@@gmail.com}.
#' @seealso For a complete application you can check the documentation of \code{\link{Krigvar}}.
#' @export
vector_integrate_kernel <- function(Kern, x, a, b, n) {
    .Call('_KRIG_vector_integrate_kernel', PACKAGE = 'KRIG', Kern, x, a, b, n)
}

#' @title Complete kernel integral.
#' @description This function is part of the routines employed in the sensitivity analysis, 
#' calculate the integral in both coordinate \eqn{x} and \eqn{y} of the kernel, over the square
#' domain give by the limits \eqn{a} and \eqn{b}. 
#' @param Kern Kernel function.
#' @param a Inferior limit for the integral in each coordinate.
#' @param b Superior limit for the integral in each coordinate.
#' @param n Number of uniform division to compute the integral.
#' @return Real value with the integral value.
#' @author Pedro Guarderas \email{pedro.felipe.guarderas@@gmail.com}.
#' @seealso For a complete application you can check the documentation of \code{\link{Krigvar}}.
#' @export
integrate_kernel <- function(Kern, a, b, n) {
    .Call('_KRIG_integrate_kernel', PACKAGE = 'KRIG', Kern, a, b, n)
}

#' @title Integrals of a list of kernels.
#' @description This function is part of the routines employed in the sensitivity analysis, 
#' computes vector of integrals and complete integrals of kernels specified in the data frame
#' Kernels.
#' @param Kernels data.frame of kernels composed by four columns.
#' \enumerate{
#'   \item Kernel name.
#'   \item Inferior limit for integral.
#'   \item Superior limit for integral.
#'   \item Number of steps for discretization of integrals.
#' }
#' @param X matrix containing in each row the coordinate where the one coordinate integrals will 
#' be evaluated.
#' @return List with one coordinate integrals and complete kernel integrals.
#' @author Pedro Guarderas \email{pedro.felipe.guarderas@@gmail.com}.
#' @seealso For a complete application you can check the documentation of \code{\link{Krigvar}}.
#' @export
list_integrate_kernel <- function(Kernels, X) {
    .Call('_KRIG_list_integrate_kernel', PACKAGE = 'KRIG', Kernels, X)
}

#' @title KANOVA, kernel anova under RKHS approximations.
#' @description Under an approximation to the sensitivity analysis based in variance computation
#' the different indexes of combinatorial sensitivity values can be computed employing the
#' values of kernel integrals.
#' @param Kernels data.frame of kernels composed by four columns.
#' \enumerate{
#'   \item Kernel name.
#'   \item Inferior limit for integral.
#'   \item Superior limit for integral.
#'   \item Number of steps for discretization of integrals.
#' }
#' @param Integral A list containing the results of kernel integrals of the functions
#' \code{\link{vector_integrate_kernel}}.
#' @param X matrix containing in each row the coordinate where the one coordinate integrals will 
#' be evaluated.
#' @return List with containing the Gamma 3D array where the different combination variance are
#' stocked and the total matrix variance named Kanova. 
#' @author Pedro Guarderas \email{pedro.felipe.guarderas@@gmail.com}.
#' @seealso For a complete application you can check the documentation of \code{\link{Krigvar}}.
#' @references
#' \insertRef{Kanova:2013}{KRIG}
#' \insertRef{Aronszajn:ThRK}{KRIG}
#' @export
Kanova <- function(Kernels, Integral, X) {
    .Call('_KRIG_Kanova', PACKAGE = 'KRIG', Kernels, Integral, X)
}

#' @title Linear kernel
#' @description Anisotropic kernel defined by the scalar product.
#' @param x first column vector.
#' @param y second column vector.
#' @param alpha amplitude parameter.
#' @return Real value.
#' @author Pedro Guarderas \email{pedro.felipe.guarderas@@gmail.com}.
#' @examples
#' n<-10
#' x<-matrix( runif( n ), n, 1 )
#' y<-matrix( runif( n ), n, 1 )
#' alpha<-0.5
#' linear_kernel( x, y, alpha )
#' @export
linear_kernel <- function(x, y, alpha) {
    .Call('_KRIG_linear_kernel', PACKAGE = 'KRIG', x, y, alpha)
}

#' @title Polynomial kernel
#' @description Anisotropic kernel defined like a polynomial in the scalar product.
#' @param x first column vector.
#' @param y second column vector.
#' @param alpha amplitude parameter.
#' @param beta displacement parameter.
#' @param n power parameter.
#' @return Real value.
#' @author Pedro Guarderas \email{pedro.felipe.guarderas@@gmail.com}.
#' N<-10
#' x<-matrix( runif( N ), N, 1 )
#' y<-matrix( runif( N ), N, 1 )
#' alpha<-0.5
#' beta<-2
#' n<-3
#' polynomial_kernel( x, y, alpha, beta, n )
#' @export
polynomial_kernel <- function(x, y, alpha, beta, n) {
    .Call('_KRIG_polynomial_kernel', PACKAGE = 'KRIG', x, y, alpha, beta, n)
}

#' @title Square kernel.
#' @description Isotropic kernel given by the square distance.
#' @param h distance variable.
#' @param alpha amplitude parameter.
#' @return Real value.
#' @author Pedro Guarderas \email{pedro.felipe.guarderas@@gmail.com}.
#' @examples
#' h<-4
#' alpha<-2
#' square_kernel( h, alpha )
#' @export
square_kernel <- function(h, alpha = 1.0) {
    .Call('_KRIG_square_kernel', PACKAGE = 'KRIG', h, alpha)
}

#' @title Triangular kernel.
#' @description Isotropic kernel defined with the max function.
#' @param h distance variable.
#' @param c amplitude parameter.
#' @param alpha maximum distance value.
#' @return Real value.
#' @author Pedro Guarderas \email{pedro.felipe.guarderas@@gmail.com}.
#' @examples
#' h<-0.2
#' c<-5
#' alpha<-2
#' triangular_kernel( h, c, alpha )
#' @export
triangular_kernel <- function(h, c = 1.0, alpha = 1.0) {
    .Call('_KRIG_triangular_kernel', PACKAGE = 'KRIG', h, c, alpha)
}

#' @title Exponential kernel.
#' @description Isotropic kernel.
#' @param h distance variable.
#' @param sigma amplitude parameter.
#' @param theta smoothness parameter.
#' @return Real value.
#' @author Pedro Guarderas \email{pedro.felipe.guarderas@@gmail.com}.
#' @examples
#' h<-0.3
#' sigma<-1.0
#' theta<-10
#' exp_kernel( h, sigma, theta )
#' @export
exp_kernel <- function(h, sigma = 1.0, theta = 1.0) {
    .Call('_KRIG_exp_kernel', PACKAGE = 'KRIG', h, sigma, theta)
}

#' @title Gaussian kernel.
#' @description Isotropic kernel.
#' @param h distance variable.
#' @param sigma amplitude parameter.
#' @param theta smoothness parameter.
#' @return Real value.
#' @author Pedro Guarderas \email{pedro.felipe.guarderas@@gmail.com}.
#' @examples
#' h<-4
#' alpha<-2
#' gaussian_kernel( h, alpha )
#' @export
gaussian_kernel <- function(h, sigma = 1.0, theta = 1.0) {
    .Call('_KRIG_gaussian_kernel', PACKAGE = 'KRIG', h, sigma, theta)
}

#' @title Spherical kernel.
#' @description Isotropic kernel commonly employed in geostatistic.
#' @param h distance variable.
#' @param phi amplitude parameter.
#' @param theta smoothness parameter.
#' @return Real value.
#' @author Pedro Guarderas \email{pedro.felipe.guarderas@@gmail.com}.
#' @examples
#' h<-4.0
#' phi<-1.0
#' theta<-100.0
#' spherical_kernel( h, phi, theta )
#' @export
spherical_kernel <- function(h, phi, theta) {
    .Call('_KRIG_spherical_kernel', PACKAGE = 'KRIG', h, phi, theta)
}

#' @title Matérn kernel.
#' @description Isotropic kernel.
#' @param h distance variable.
#' @param v power parameter.
#' @param sigma amplitude parameter.
#' @param theta smoothness parameter.
#' @return Real value.
#' @author Pedro Guarderas \email{pedro.felipe.guarderas@@gmail.com}.
#' @examples
#' h<-4.0
#' v<-2.0
#' sigma<-2.0
#' theta<-100.0
#' matern_kernel( h, v, sigma, theta )
#' @export
matern_kernel <- function(h, v = 2.0, sigma = 1.0, theta = 1.0) {
    .Call('_KRIG_matern_kernel', PACKAGE = 'KRIG', h, v, sigma, theta)
}

#' @title Multilog kernel.
#' @description Isotropic kernel.
#' @param h distance parameter.
#' @param R displacement parameter.
#' @return Real value.
#' @author Pedro Guarderas \email{pedro.felipe.guarderas@@gmail.com}.
#' @examples
#' h<-4
#' R<-2.3
#' multilog_kernel( h, R )
#' @export
multilog_kernel <- function(h, R = 1.0) {
    .Call('_KRIG_multilog_kernel', PACKAGE = 'KRIG', h, R)
}

#' @title Natural cubic spline kernel.
#' @description Isotropic kernel.
#' @param h distance variable.
#' @param R displacement parameter.
#' @return Real value.
#' @author Pedro Guarderas \email{pedro.felipe.guarderas@@gmail.com}.
#' @examples
#' h<-4.0
#' R<-2.3
#' nat_cubic_spline_kernel( h, R )
#' @export
nat_cubic_spline_kernel <- function(h, R = 1.0) {
    .Call('_KRIG_nat_cubic_spline_kernel', PACKAGE = 'KRIG', h, R)
}

#' @title Thin plate kernel.
#' @description Isotropic kernel.
#' @param h distance variable. 
#' @param R displacement parameter.
#' @return Real value.
#' @author Pedro Guarderas \email{pedro.felipe.guarderas@@gmail.com}.
#' @examples
#' h<-4.0
#' R<-0.5
#' thin_plate_kernel( h, R )
#' @export
thin_plate_kernel <- function(h, R = 1.0) {
    .Call('_KRIG_thin_plate_kernel', PACKAGE = 'KRIG', h, R)
}

#' @title Spatial covariance matrix.
#' @description To compute a kriging, it is necessary the spatial covariance matrix. The spatial 
#'   covariance could computed between to sets of points X and Y with different dimension and the 
#'   result it is not necessarily a square matrix.
#' @param X First set of spatial points.
#' @param Y Second set of spatial points.
#' @param Kern Kernel function.
#' @param symmetric If result of computation will be a square matrix, the time computation can
#'   be improved setting this parameter to TRUE, the default is FALSE.
#' @return The spatial covariance matrix.
#' @author Pedro Guarderas \email{pedro.felipe.guarderas@@gmail.com}.
#' @useDynLib KRIG
#' @importFrom Rcpp sourceCpp
#' @exportPattern("^[[:alpha:]]+")
#' @seealso For a complete application you can check the documentation of \code{\link{Krig}}.
#' @export
Kov <- function(X, Y, Kern, symmetric = FALSE) {
    .Call('_KRIG_Kov', PACKAGE = 'KRIG', X, Y, Kern, symmetric)
}

#' @title Kriging computation.
#' @description Computes the kriging linear estimator for different types of kriging models.
#' @param Z Observed values of the spatial process.
#' @param K Covariance matrix computed for the position \eqn{X} where the spatial process \eqn{Z}
#' was observed.
#' @param k Covariance matrix computed for the position \eqn{X} where the spatial process \eqn{Z}
#' was observed and the position \eqn{Y} where the spatial process \eqn{Z} will be predicted.
#' @param G When universal kriging will be computed, this matrix represents the values of the 
#' of the functions representing the mean of the process \eqn{Z}, evaluated in the spatial 
#' points \eqn{X} where the spatial process was first observed.
#' @param g When universal kriging will be computed, this matrix represents the evaluation of the
#' functions representing the mean over the new position points \eqn{Y} where the spatial process
#' \eqn{Z} will be predicted. 
#' @param type Type of kriging model, possible values are: simple, ordinary, universal.
#' @param cinv Specifies how the inverse of the covariance matrix \eqn{K} will be computed. 
#' Possible values are: syminv = symmetric matrix inverse computation, inv = usual armadillo
#' inverse computation, cholinv = Cholesky based inverse computation, ginv = given inverse not
#' necessary to compute inverse at all.
#' @return Depending of the type of analysis the list of results change.
#' \item{Z}{New estimated values for Z.}
#' \item{L}{Linear coefficients determined by kriging.}
#' \item{J}{Inverse of the covariance matrix.}
#' \item{tau}{Factor computed in the ordinary and universal kriging.}
#' \item{alpha}{Factor computed in the ordinary kriging.}
#' \item{A}{Factor computed in the universal kriging.}
#' @author Pedro Guarderas \email{pedro.felipe.guarderas@@gmail.com}.
#' @examples
#' library( KRIG )
#' vignette( topic = 'simple_kriging', package = 'KRIG' )
#' vignette( topic = 'ordinary_kriging', package = 'KRIG' )
#' vignette( topic = 'universal_kriging', package = 'KRIG' )
#' vignette( topic = 'copper_mining_2d', package = 'KRIG' )
#' @export
Krig <- function(Z, K, k, G, g, type = "ordinary", cinv = "syminv") {
    .Call('_KRIG_Krig', PACKAGE = 'KRIG', Z, K, k, G, g, type, cinv)
}

#' @title Combinatorial variance computation.
#' @description For a given combination this function computes the associated variance for the
#' variable enumerated by the combination values.
#' @param KF values of the kernel integral evaluations.
#' @param comb Combination.
#' @param X Points in the grid.
#' @param Gamma Cube with integral results.
#' @return Real value of sensitivity.
#' @author Pedro Guarderas \email{pedro.felipe.guarderas@@gmail.com}.
#' @seealso For a complete application you can check the documentation of \code{\link{Krigvar}}.
#' @references
#' \insertRef{Kanova:2013}{KRIG}
#' \insertRef{Aronszajn:ThRK}{KRIG}
#' @export
Krigidx <- function(KF, comb, X, Gamma) {
    .Call('_KRIG_Krigidx', PACKAGE = 'KRIG', KF, comb, X, Gamma)
}

#' @title Combinatorial variance computation.
#' @description Computation of variance
#' @param KF values of the kernel integral evaluations.
#' @param Gamma Cube with integral results.
#' @return Real value of sensitivity.
#' @author Pedro Guarderas \email{pedro.felipe.guarderas@@gmail.com}.
#' @examples
#' library( KRIG ) 
#' options( stringsAsFactors = FALSE )
#'  
#' kernel_1<-function( x, y ) exp( -0.5*(x-y)^2)
#' kernel_2<-function( x, y ) exp( -0.7*(x-y)^2)
#' kernel_3<-function( x, y ) exp( -0.1*(x-y)^2)
#' 
#' Kernels<-data.frame( kernel = c( 'kernel_1', 'kernel_2', 'kernel_3' ), 
#'                      min = c( -1, -1, -2 ), 
#'                      max = c( 1, 1, 2 ),
#'                      n = c( 100, 100, 100 ) )
#'                      
#' n<-20
#' X<-matrix( c( seq( -1, 1, length.out = n ), 
#'               seq( -1, 1, length.out = n ),
#'               seq( -2, 2, length.out = n ) ), n, 3 )
#'               
#' KI<-list_integrate_kernel( Kernels, X )
#' GK<-Kanova( Kernels, KI, X )
#'     
#' f<-function( x ) x[1] + 30 * x[2] + 60 * x[3]
#' Func<-apply( X, 1, FUN = f )
#'     
#' KF<-solve( GK$Kanova + diag( 1e-8, n, n ), Func )
#'     
#' SbI<-NULL
#' for ( j in 1:3 ) {
#'   CB<-combn( 1:3, j )  
#'   for ( l in 1:ncol( CB ) ) {
#'     SbI<-c( SbI, Krigidx( KF, CB[,l], X, GK$Gamma ) )
#'     names(SbI)[length(SbI)]<-paste( 'C.', paste( CB[,l], collapse='.' ), sep = '' )
#'   }
#' }
#'   
#' Var<-Krigvar( KF, GK$Gamma )
#'     
#' SVar<-sum( SbI / Var )
#' 
#' @references
#' \insertRef{Kanova:2013}{KRIG}
#' \insertRef{Aronszajn:ThRK}{KRIG}
#' 
#' @export
Krigvar <- function(KF, Gamma) {
    .Call('_KRIG_Krigvar', PACKAGE = 'KRIG', KF, Gamma)
}

#' @title Computes the variogram.
#' @description This useful function is commonly employed in the study of isotropic stationary 
#' spatial processes. 
#' @param Z Vector of observations.
#' @param X Points matrix.
#' @param d Distance function.
#' @return Variogram vector.
#' @author Pedro Guarderas \email{pedro.felipe.guarderas@@gmail.com}.
#' @examples
#' library( KRIG )
#' vignette( topic = 'copper_mining_2d', package = 'KRIG' )
#' @export
variogram <- function(Z, X, d) {
    .Call('_KRIG_variogram', PACKAGE = 'KRIG', Z, X, d)
}

