#' @description
#' \tabular{ll}{
#' Package: \tab KenSyn\cr
#' Type: \tab Package\cr
#' Version: \tab 0.2\cr
#' Date: \tab 2017-12-10\cr
#' License: \tab LGPL-3 \cr
#' LazyLoad: \tab yes\cr
#' LazyData: \tab yes\cr
#' Depends: \tab R(>= 3.0.0)\cr
#' Imports: \tab nlme, lme4, metafor\cr
#' }
#'
#' \strong{KenSyn}
#' Knowledge Synthesis in Agriculture - From Experimental Network to Meta-Analysis.
#'
#' Demo and dataset accompaying the book (in preparation) \strong{Knowledge Synthesis in Agriculture : from Experimental Network to Meta-Analysis} (Quae, for french version) by David Makowski, Francois Piraux and Francois Brun)
#'
#' A full description of all the material is in the book.
#'
#' \strong{ACKNOWLEDGMENTS}
#' The French network "RMT modeling and data analysis for agriculture", \url{http://www.modelia.org}) have contributed to the development of this R package. This project and network are lead by ACTA (French Technical Institute for Agriculture) and was funded by a grant from the Ministry of Agriculture and Fishing of France.
#'
#' @name KenSyn-package
#' @aliases KenSyn
#' @docType package
#' @title Knowledge Synthesis in Agriculture - From Experimental Network to Meta-Analysis
#' @author  Francois Brun (ACTA)  \email{francois.brun@@acta.asso.fr}, David Makowski (INRA), Francois Piraux (Arvalis)
#' @references Synthetiser la connaissance : de l'analyse de reseaux experimentaux a la meta-analyse
#' \url{http://www.modelia.org}
#' @keywords agricultural agronomy crop environment meta-analysis mixted-model
NA
