% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/causal_loci.R
\name{causal_loci}
\alias{causal_loci}
\title{Identification of causal loci}
\usage{
causal_loci(window, M = 10, fdr = 0.15)
}
\arguments{
\item{window}{The result window from KnockoffTrio. If there are multiple windows, please use rbind to combine the windows.}

\item{M}{A positive integer for the number of knockoffs. The default is 10.}

\item{fdr}{A real number in a range of (0,1) indicating the target FDR level. The default is 0.15.}
}
\value{
A list that contains:
\describe{
  \item{window}{A data frame for an updated window that includes an extra column for KnockoffTrio's Q-values. A locus with a Q-value <= the target FDR level, i.e., window$q<=fdr, is considered as causal.}
  \item{thr.w}{A positive real number indicating the significance threshold for KnockoffTrio's feature statistics. A locus with a feature statistic >= thr.w, i.e., window$w>=thr.w is considered as causal. The loci selected by window$w>=thr.w are equivalent to those by window$q<=fdr. No loci are selected at the target FDR level if thr.w=Inf.}
}
}
\description{
Identification of causal loci using KnockoffTrio's feature statistics
}
\examples{
data(KnockoffTrio.example)
dat.ko<-create_knockoff(KnockoffTrio.example$dat.hap,KnockoffTrio.example$pos,M=10)
window<-KnockoffTrio(KnockoffTrio.example$dat,dat.ko,KnockoffTrio.example$pos)
result<-causal_loci(window,M=10,fdr=0.15)
}
