/*
 * Decompiled with CFR 0.152.
 */
package kr.pe.freesearch.jhannanum.comm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import kr.ac.kaist.swrc.jhannanum.comm.Eojeol;
import kr.ac.kaist.swrc.jhannanum.comm.Sentence;
import kr.ac.kaist.swrc.jhannanum.hannanum.Workflow;
import kr.ac.kaist.swrc.jhannanum.plugin.MajorPlugin.MorphAnalyzer.ChartMorphAnalyzer.KoNLPChartMorphAnalyzer;
import kr.ac.kaist.swrc.jhannanum.plugin.MajorPlugin.PosTagger.HmmPosTagger.KoNLPHMMTagger;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.MorphemeProcessor.UnknownMorphProcessor.UnknownProcessor;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.PlainTextProcessor.InformalSentenceFilter.InformalSentenceFilter;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.PlainTextProcessor.SentenceSegmentor2.SentenceSegmentor2;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.PosProcessor.NounExtractor.NounExtractor;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.PosProcessor.SimplePOSResult09.SimplePOSResult09;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.PosProcessor.SimplePOSResult22.SimplePOSResult22;

public class HannanumInterface {
    private static Workflow wf = null;

    public void reloadAllDic() {
        if (wf != null) {
            wf.clear();
            wf = null;
        }
        System.gc();
    }

    public int reloadUserDic(String dicPath, String work) throws IOException {
        if (work.equals("extractNoun")) {
            if (wf != null) {
                wf.reloadUserDic(dicPath);
                return 0;
            }
            return -1;
        }
        if (work.equals("SimplePos09")) {
            if (wf != null) {
                wf.reloadUserDic(dicPath);
                return 0;
            }
            return -1;
        }
        if (work.equals("SimplePos22")) {
            if (wf != null) {
                wf.reloadUserDic(dicPath);
                return 0;
            }
            return -1;
        }
        if (work.equals("MorphAnalyzer")) {
            if (wf != null) {
                wf.reloadUserDic(dicPath);
                return 0;
            }
            return -1;
        }
        return -2;
    }

    public void reloadUserDic(String dicPath) throws IOException {
        if (wf != null) {
            wf.reloadUserDic(dicPath);
        }
        System.gc();
    }

    public String[] extractNoun(String basedir, String sentence, String userDicFile) {
        if (wf != null && wf.getCtx() != "extractNoun") {
            wf.clear();
            wf = null;
        }
        if (wf == null) {
            wf = new Workflow(basedir, "extractNoun");
            wf.appendPlainTextProcessor(new SentenceSegmentor2(), null);
            wf.appendPlainTextProcessor(new InformalSentenceFilter(), null);
            wf.setMorphAnalyzer(new KoNLPChartMorphAnalyzer(), "conf/plugin/MajorPlugin/MorphAnalyzer/ChartMorphAnalyzer.json");
            wf.setMorphUserDic(userDicFile);
            wf.appendMorphemeProcessor(new UnknownProcessor(), null);
            wf.setPosTagger(new KoNLPHMMTagger(), "conf/plugin/MajorPlugin/PosTagger/HmmPosTagger.json");
            wf.appendPosProcessor(new NounExtractor(), null);
            try {
                wf.activateWorkflow(false);
            }
            catch (Exception e) {
                e.printStackTrace();
                wf.close();
                wf = null;
                return null;
            }
        }
        ArrayList<String> list = null;
        try {
            wf.analyze(sentence);
            LinkedList<Sentence> resultList = wf.getResultOfDocument(new Sentence(0, 0, false));
            list = new ArrayList<String>();
            for (Sentence s : resultList) {
                Eojeol[] eojeolArray = s.getEojeols();
                int i = 0;
                while (i < eojeolArray.length) {
                    if (eojeolArray[i].length > 0) {
                        String[] morphemes = eojeolArray[i].getMorphemes();
                        int j = 0;
                        while (j < morphemes.length) {
                            list.add(morphemes[j]);
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            wf.close();
            return null;
        }
        wf.close();
        return list.toArray(new String[0]);
    }

    public String MorphAnalyzer(String basedir, String sentence, String userDicFile) {
        if (wf != null && wf.getCtx() != "MorphAnalyzer") {
            wf.clear();
            wf = null;
        }
        if (wf == null) {
            wf = new Workflow(basedir, "MorphAnalyzer");
            wf.appendPlainTextProcessor(new SentenceSegmentor2(), null);
            wf.appendPlainTextProcessor(new InformalSentenceFilter(), null);
            wf.setMorphAnalyzer(new KoNLPChartMorphAnalyzer(), "conf/plugin/MajorPlugin/MorphAnalyzer/ChartMorphAnalyzer.json");
            wf.setMorphUserDic(userDicFile);
            wf.appendMorphemeProcessor(new UnknownProcessor(), null);
            try {
                wf.activateWorkflow(false);
            }
            catch (Exception e) {
                e.printStackTrace();
                wf.close();
                wf = null;
                return null;
            }
        }
        String morphs = null;
        try {
            wf.analyze(sentence);
            morphs = wf.getResultOfDocument();
            wf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            wf.close();
            return null;
        }
        wf.close();
        return morphs;
    }

    public String SimplePos22(String basedir, String sentence, String userDicFile) {
        if (wf != null && wf.getCtx() != "SimplePos22") {
            wf.clear();
            wf = null;
        }
        if (wf == null) {
            wf = new Workflow(basedir, "SimplePos22");
            wf.appendPlainTextProcessor(new SentenceSegmentor2(), null);
            wf.appendPlainTextProcessor(new InformalSentenceFilter(), null);
            wf.setMorphAnalyzer(new KoNLPChartMorphAnalyzer(), "conf/plugin/MajorPlugin/MorphAnalyzer/ChartMorphAnalyzer.json");
            wf.setMorphUserDic(userDicFile);
            wf.appendMorphemeProcessor(new UnknownProcessor(), null);
            wf.setPosTagger(new KoNLPHMMTagger(), "conf/plugin/MajorPlugin/PosTagger/HmmPosTagger.json");
            wf.appendPosProcessor(new SimplePOSResult22(), null);
            try {
                wf.activateWorkflow(false);
            }
            catch (Exception e) {
                e.printStackTrace();
                wf.close();
                wf = null;
                return null;
            }
        }
        String morphs = null;
        try {
            wf.analyze(sentence);
            morphs = wf.getResultOfDocument();
        }
        catch (Exception e) {
            e.printStackTrace();
            wf.close();
            return null;
        }
        wf.close();
        return morphs;
    }

    public String SimplePos09(String basedir, String sentence, String userDicFile) {
        if (wf != null && wf.getCtx() != "SimplePos09") {
            wf.clear();
            wf = null;
        }
        if (wf == null) {
            wf = new Workflow(basedir, "SimplePos09");
            wf.appendPlainTextProcessor(new SentenceSegmentor2(), null);
            wf.appendPlainTextProcessor(new InformalSentenceFilter(), null);
            wf.setMorphAnalyzer(new KoNLPChartMorphAnalyzer(), "conf/plugin/MajorPlugin/MorphAnalyzer/ChartMorphAnalyzer.json");
            wf.setMorphUserDic(userDicFile);
            wf.appendMorphemeProcessor(new UnknownProcessor(), null);
            wf.setPosTagger(new KoNLPHMMTagger(), "conf/plugin/MajorPlugin/PosTagger/HmmPosTagger.json");
            wf.appendPosProcessor(new SimplePOSResult09(), null);
            try {
                wf.activateWorkflow(false);
            }
            catch (Exception e) {
                e.printStackTrace();
                wf.close();
                wf = null;
                return null;
            }
        }
        String morphs = null;
        try {
            wf.analyze(sentence);
            morphs = wf.getResultOfDocument();
        }
        catch (Exception e) {
            e.printStackTrace();
            wf.close();
            return null;
        }
        wf.close();
        return morphs;
    }

    public static void main(String[] args) throws IOException {
        HannanumInterface hi = new HannanumInterface();
        String[] ret1 = hi.extractNoun("C:/R/R-3.3.2/library/Sejong/dics/handic.zip", "\u3141\u3147\u3141\u3134\u3147\u3141\u3134\u3147\u3141\u3147\u3141\u3134\u3147\u3141\u3134\u3147\u3141\u3134\u3147\u3134\u314a\uc544\uce30\ub098\uc778\ub9c8\uc5c4\ub098\uc5c4\uc544", "C:/R/R-3.3.2/library/KoNLP/../KoNLP_dic/current/dic_user.txt");
        int i1 = 0;
        while (i1 < ret1.length) {
            System.out.println(ret1[i1]);
            ++i1;
        }
        System.out.println("test");
        System.out.println(hi.SimplePos22("C:/Users/gogamza/Documents/work/Sejong/inst/dics/handic.zip", "'\uc778\ud130\ub137 \uc18c\uc124\uc774 \ub4f1\uc7a5\ud558\uba74\uc11c' \uc18c\uc124\uc744 \uc4f0\ub294 \uc0ac\ub78c\ub4e4\uc774 \ub298\uc5b4\ub098\uae34 \ud588\uc9c0\ub9cc \t\t\t", "C:/R/R-3.3.2/library/KoNLP/../KoNLP_dic/current/dic_user.txt"));
        System.out.println(hi.SimplePos09("C:/Users/gogamza/Documents/work/Sejong/inst/dics/handic.zip", "'\uc778\ud130\ub137 \uc18c\uc124\uc774 \ub4f1\uc7a5\ud558\uba74\uc11c' \uc18c\uc124\uc744 \uc4f0\ub294 \uc0ac\ub78c\ub4e4\uc774 \ub298\uc5b4\ub098\uae34 \ud588\uc9c0\ub9cc, \uc18c\uc124\uc744 \uc77d\ub294 \uc0ac\ub78c\uc774 \uc904\uc5b4\ub4e4\uba74\uc11c \uadf8\ub4e4\ub9cc\uc758 \uc138\uacc4\uac00 \ub418\uc5b4 \ubc84\ub838\ub2e4. \uadf8\ub7ec\ub098 \uc774\ud6c4 \uad6d\ub0b4 \uc18c\uc124\uacc4\uc5d0\uc11c \ubb34\uc2dc\ud560 \uc218 \uc5c6\ub294 \ube44\uc911\uc744 \ucc28\uc9c0\ud558\uac8c \ub41c \uc591\ud310\uc18c\uc640 \uadc0\uc5ec\ub2c8\ub958 \uc5f0\uc560\uc18c\uc124\uc740 \ubd88\uc3d8\uc2dc\uac1c \ucde8\uae09 \ubc1b\uc73c\uba70 \uc2dc\uac04\ub54c\uc6b0\uae30\uc5d0 \ubd88\uacfc\ud558\ub2e4\ub294 \ud3c9\uac00\ub97c \uc790\uc8fc \ubc1b\uace4 \ud558\uc9c0\ub9cc, \uc560\ucd08\uc5d0 \uc2dc\uac04\ub54c\uc6b0\uae30 \uc6a9\uc774\ub77c\ub294 \ub9d0\uc740 \ubc14\uafd4 \ub9d0\ud558\uba74 \uc2dc\uac04\uc744 \ub54c\uc6b8 \uc815\ub3c4\ub294 \ub41c\ub2e4\ub294 \uc774\uc57c\uae30\ub2e4. \uacb0\uad6d \uc544\ubb34\ub9ac \uae4c\uc5ec\ub3c4 \ubcf4\ub294 \uc0ac\ub78c\uc774 \uc788\uae30 \ub54c\ubb38\uc5d0 \uc4f0\uace0 \uadf8\uac83\uc774 \ucd9c\ud310\uc73c\ub85c \uc774\uc5b4\uc9c0\ub294 \uac83\uc774\ub2e4. \ud2b9\ud788 \uadc0\uc5ec\ub2c8\uc758 \uc18c\uc124\ub4e4\uc740 \uc778\ud130\ub137 \uc18c\uc124\uc774 \ubcf8\uaca9\uc801\uc73c\ub85c \ud14d\uc2a4\ud2b8\ud654, \uc989 \ucd9c\ud310\uc774 \ub418\ub294 \uc2dc\ubc1c\uc810\uc774 \ub418\uc5c8\ub2e4\ub294 \uc810\uc5d0\uc11c \uc5ec\ub7ec\ubaa8\ub85c \uc758\uc758\uac00 \uc788\ub2e4\uace0 \ud560 \uc218 \uc788\ub2e4. \uc0ac\uc2e4 \ubb38\ud559\uacc4\uc5d0\uc11c \uc628\ub77c\uc778\uc758 \uae00\uc774 \uc774\ubaa8\ud2f0\ucf58\uacfc \ub9de\ucda4\ubc95.\uc744 \uc548 \uc9c0\ud0a4\uace0 \uadf8\ub300\ub85c. \ud65c\uc790\ud654 \ub41c \uac83\uc740 \uc5c4\uccad\ub09c \ud601\uba85\uc774\ub77c\uace0 \ub9d0\ud560 \uc218 \uc788\ub2e4. \uae4c\ub294\uac70\uc57c \uae4c\uc5ec\uc57c \ud558\ub294 \uac70\uc9c0\ub9cc \uc77c\ub2e8 \uc774\ub7f0 \uc758\uc758\uac00 \uc788\ub2e4\ub294\uac74 \uc54c\uc544\ub450\uc790.  U.S. A. Introduction. I'm fine... 12.42", "C:/Users/gogamza/Documents/work/Sejong/inst/dics/handic/data/kE/dic_user2.txt"));
        System.out.println("end");
        System.out.println("2 time\n");
        String ret2 = hi.MorphAnalyzer("C:/R/R-3.3.2/library/Sejong/dics/handic.zip", "'\uc778\ud130\ub137 \uc18c\uc124\uc774 \ub4f1\uc7a5\ud558\uba74\uc11c  ' \uc18c\uc124\uc744 \uc4f0\ub294 \uc0ac\ub78c\ub4e4\uc774 \ub298\uc5b4\ub098\uae34 \ud588\uc9c0\ub9cc, \uc18c\uc124\uc744 \uc77d\ub294 \uc0ac\ub78c\uc774 \uc904\uc5b4\ub4e4\uba74\uc11c \uadf8\ub4e4\ub9cc\uc758 \uc138\uacc4\uac00 \ub418\uc5b4 \ubc84\ub838\ub2e4. \n\uadf8\ub7ec\ub098 \uc774\ud6c4 \uad6d\ub0b4 \uc18c\uc124\uacc4\uc5d0\uc11c \ubb34\uc2dc\ud560 \uc218 \uc5c6\ub294 \ube44\uc911\uc744 \ucc28\uc9c0\ud558\uac8c \ub41c \uc591\ud310\uc18c\uc640 \uadc0\uc5ec\ub2c8\ub958 \uc5f0\uc560\uc18c\uc124\uc740 \ubd88\uc3d8\uc2dc\uac1c \ucde8\uae09 \ubc1b\uc73c\uba70 \uc2dc\uac04\ub54c\uc6b0\uae30\uc5d0 \ubd88\uacfc\ud558\ub2e4\ub294 \ud3c9\uac00\ub97c \uc790\uc8fc \ubc1b\uace4 \ud558\uc9c0\ub9cc, \uc560\ucd08\uc5d0 \uc2dc\uac04\ub54c\uc6b0\uae30 \uc6a9\uc774\ub77c\ub294 \ub9d0\uc740 \ubc14\uafd4 \ub9d0\ud558\uba74 \uc2dc\uac04\uc744 \ub54c\uc6b8 \uc815\ub3c4\ub294 \ub41c\ub2e4\ub294 \uc774\uc57c\uae30\ub2e4. \uacb0\uad6d \uc544\ubb34\ub9ac \uae4c\uc5ec\ub3c4 \ubcf4\ub294 \uc0ac\ub78c\uc774 \uc788\uae30 \ub54c\ubb38\uc5d0 \uc4f0\uace0 \uadf8\uac83\uc774 \ucd9c\ud310\uc73c\ub85c \uc774\uc5b4\uc9c0\ub294 \uac83\uc774\ub2e4. \ud2b9\ud788 \uadc0\uc5ec\ub2c8\uc758 \uc18c\uc124\ub4e4\uc740 \uc778\ud130\ub137 \uc18c\uc124\uc774 \ubcf8\uaca9\uc801\uc73c\ub85c \ud14d\uc2a4\ud2b8\ud654, \uc989 \ucd9c\ud310\uc774 \ub418\ub294 \uc2dc\ubc1c\uc810\uc774 \ub418\uc5c8\ub2e4\ub294 \uc810\uc5d0\uc11c \uc5ec\ub7ec\ubaa8\ub85c \uc758\uc758\uac00 \uc788\ub2e4\uace0 \ud560 \uc218 \uc788\ub2e4. \uc0ac\uc2e4 \ubb38\ud559\uacc4\uc5d0\uc11c \uc628\ub77c\uc778\uc758 \uae00\uc774 \uc774\ubaa8\ud2f0\ucf58\uacfc \ub9de\ucda4\ubc95.\uc744 \uc548 \uc9c0\ud0a4\uace0 \uadf8\ub300\ub85c. \ud65c\uc790\ud654 \ub41c \uac83\uc740 \uc5c4\uccad\ub09c \ud601\uba85\uc774\ub77c\uace0 \ub9d0\ud560 \uc218 \uc788\ub2e4. \uae4c\ub294\uac70\uc57c \uae4c\uc5ec\uc57c \ud558\ub294 \uac70\uc9c0\ub9cc \uc77c\ub2e8 \uc774\ub7f0 \uc758\uc758\uac00 \uc788\ub2e4\ub294\uac74 \uc54c\uc544\ub450\uc790.  U.S. A. Introduction. I'm fine... 12.42", "C:/R/R-3.3.2/library/KoNLP/../KoNLP_dic/current/dic_user.txt");
        System.out.println(ret2);
    }
}

