% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Koboconnect.R
\name{kobo_df_download}
\alias{kobo_df_download}
\title{Creates a data frame after creating a 'csv' export and downloading it}
\usage{
kobo_df_download(
  url = "kobo.humanitarianresponse.info",
  uname = "",
  pwd = "",
  assetid = "",
  all = "false",
  lang = "_default",
  hierarchy = "false",
  include_grp = "true",
  grp_sep = "/",
  fsep = ";",
  multi_sel = "both",
  media_url = "true",
  fields = NULL,
  sub_ids = NULL,
  sleep = 2
)
}
\arguments{
\item{url}{The `[url]` of kobotoolbox Default is "kobo.humanitarianresponse.info".}

\item{uname}{is username of your kobotoolbox account}

\item{pwd}{is the password of the account}

\item{assetid}{is the id of the asset for which the export is to be created}

\item{all}{takes logical value in string format. Used to specify whether fields from all form versions will be included in the export.Acceptable values are "true" or "false". Default value is "false".}

\item{lang}{takes the language. For e.g. "English (en)".}

\item{hierarchy}{takes logical value in string format. Used to specify whether the group hierarchy will be displayed in labels. Acceptable values are "true" or "false". Default value is "false".}

\item{include_grp}{defines whether or not to include groups. Default value is "true".}

\item{grp_sep}{is the group separator. Default value is "/".}

\item{fsep}{is the separator of the downloaded csv file. In most of the cases, it is ";", which is the default. However,
if you notice that the separator is the downloaded data is "," or something else, you can change it.}

\item{multi_sel}{is used to specify the display of multiple_select-type responses. Valid inputs include "both", "summary" or "details". Default is "both".}

\item{media_url}{This will include an additional column for media-type questions ("question_name_URL") with the URL link to the hosted file. Valid inputs are "true" or "false". Default value is true.}

\item{fields}{is an array of column names to be included in the export (including their group hierarchy). Valid inputs include:
An array containing any string value that matches the XML column name,
An empty array which will result in all columns being included,
If "fields" is not included in the "export_settings", all columns will be included in the export}

\item{sub_ids}{is an array of submission ids that will filter exported submissions to only the specified array of ids. Valid inputs include an array containing integer values or an empty array.}

\item{sleep}{is the sleep time between API actions. For example, it takes time to download an export. But R does not wait for the download to finish before going to next step. Hence the need to provide a break between consecutive API actions. Default value is 2 (seconds).}
}
\value{
The function returns a data frame of data downloaded from 'Kobotoolbox'.
}
\description{
`kobo_df_download` is a wrapper for kobotoolbox API `https://[url]/exports/..`
}
\details{
The function creates an export of survey data in 'csv'. If successful, it attempts to download the data and and return a data frame.
}
