% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/MdeFunc.R
\name{KoulLrMde}
\alias{KoulLrMde}
\title{Performs minimum distance estimation in linear regression model: Y=Xb + error}
\usage{
KoulLrMde(Y, X)
}
\arguments{
\item{Y}{- Response variable in linear regression model}

\item{X}{- Explanatory variable in linear regression model}
}
\value{
Returns betahat - Minimum distance estimator of b
}
\description{
Performs minimum distance estimation in linear regression model: Y=Xb + error
}
\examples{
####################
n <- 10
p <- 3
X <- matrix(rnorm(n*p, 5,3), nrow=n, ncol=p)  #### Generate n-by-p design matrix X
beta <- c(-2, 0.3, 1.5)                       #### Generate true beta = (-2, 0.3, 1.5)'
eps <- rnorm(n, 0,1)                          #### Generate errors from N(0,1)
Y <- X\%*\%beta + eps
#####################

betahat <- KoulLrMde(Y,X)                     ##### Obtain minimum distance estimator betahat
}
\references{
[1] Koul, H. L (1985). Minimum distance estimation in linear regression with unknown error distributions. Statist. Probab. Lett., 3 1-8.

[2] Koul, H. L (1986). Minimum distance estimation and goodness-of-fit tests in first-order autoregression. Ann. Statist., 14 1194-1213.

[3] Koul, H. L (2002). Weighted empirical process in nonlinear dynamic models. Springer, Berlin, Vol. 166
}
\seealso{
KoulArMde()
}

