% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TS_on_LDA.R
\name{check_LDA_models}
\alias{check_LDA_models}
\title{Check that LDA model input is proper}
\usage{
check_LDA_models(LDA_models)
}
\arguments{
\item{LDA_models}{List of LDA models or singular LDA model to evaluate.}
}
\value{
An error message is thrown if \code{LDA_models} is not proper,
  else \code{NULL}.
}
\description{
Check that the \code{LDA_models} input is either a set of 
  LDA models (class \code{LDA_set}, produced by
  \code{\link{LDA_set}}) or a singular LDA model (class \code{LDA},
  produced by \code{\link[topicmodels]{LDA}}).
}
\examples{
  data(rodents)
  document_term_table <- rodents$document_term_table
  document_covariate_table <- rodents$document_covariate_table
  LDAs <- LDA_set(document_term_table, topics = 2, nseeds = 1)
  LDA_models <- select_LDA(LDAs)
  check_LDA_models(LDA_models)

}
