% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multinom_TS.R
\name{logLik.multinom_TS_fit}
\alias{logLik.multinom_TS_fit}
\title{Log likelihood of a multinomial TS model}
\usage{
\method{logLik}{multinom_TS_fit}(object, ...)
}
\arguments{
\item{object}{A \code{multinom_TS_fit}-class object.}

\item{...}{Not used, simply included to maintain method compatibility.}
}
\value{
Log likelihood of the model, as class \code{logLik}, with 
  attributes \code{df} (degrees of freedom) and \code{nobs} (the number of
  weighted observations, accounting for size differences among documents).
}
\description{
Convenience function to simply extract the \code{logLik}
  element (and \code{df} and \code{nobs}) from a \code{multinom_TS_fit}
  object fit by \code{\link{multinom_TS}}. Extends 
  \code{\link[stats]{logLik}} from \code{\link[nnet]{multinom}} to 
  \code{multinom_TS_fit} objects.
}
\examples{
  data(rodents)
  dtt <- rodents$document_term_table
  lda <- LDA_set(dtt, 2, 1, list(quiet = TRUE))
  dct <- rodents$document_covariate_table
  dct$gamma <- lda[[1]]@gamma
  weights <- document_weights(dtt)
  mts <- multinom_TS(dct, formula = gamma ~ 1, changepoints = c(20,50),
                     timename = "newmoon", weights = weights)
  logLik(mts)

}
