% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots.R
\name{AIP_DensityPlotOfbootst}
\alias{AIP_DensityPlotOfbootst}
\title{Plot density of bootstrap and empirical variance for AIP}
\usage{
AIP_DensityPlotOfbootst(
  DF,
  title = "",
  empirVrnc,
  errPropVrnc,
  errPropVrnc2Ord
)
}
\arguments{
\item{DF}{A data frame containing the bootstrap variances of AIP.}

\item{title}{Title of the plot (default="").}

\item{empirVrnc}{Value of the empirical (experimental) variance of AIP.}

\item{errPropVrnc}{Value of the first order error propagation variance of AIP.}

\item{errPropVrnc2Ord}{Value of the second order error propagation variance of AIP.}
}
\value{
Plots the respective plot.
}
\description{
Plot density of the bootstrap variance for AIP along with the median,
2.5 and 97.5 percentile as vertical lines. Also plots the empirical variance
as a segment from the bottom to the middle of the graph and the error
propagation variance as a line segment from the top to the middle of the
graph. DF must the dataframe of the list returned from the respective
(LDL or AIP) Bootstrap variance function.
}
\examples{
\dontrun{
sampleA$AIP = AIPcalc(sampleA$TG,sampleA$HDL, SI=FALSE)
AIP_empirVrnc=var(sampleA$AIP)
AIP_errPropVrnc=AIPErrPrp(sampleA$TG,sampleA$HDL, SI=FALSE)
AIP_errPropVrnc2Ord=AIPErrPrp2Ord(sampleA$TG,sampleA$HDL, SI=FALSE)
DfAIPboost=as.data.frame(AIPbootVrnc(sampleA$TG,sampleA$HDL, SI=FALSE))
AIP_DensityPlotOfbootst(DfAIPboost,"Title",AIP_empirVrnc, AIP_errPropVrnc, AIP_errPropVrnc2Ord)
}
}
