\name{LDheatmap.addRecombRate}
\alias{LDheatmap.addRecombRate}
\title{
Add recombination rate plot to an LD heat map.
}
\description{
Retrieve average rates of recombination from the deCODE genetic map from the UCSC 
Genome Browser and add them to an LDheatmap object.
}
\usage{
LDheatmap.addRecombRate(LDheatmap, chromosome, genome = NULL, recombRateLocation = 0.02, view = "dense")
}
\arguments{
  \item{LDheatmap}{
An object of class LDheatmap.
}
  \item{chromosome}{
A character string that identifies the chromosome.
}
  \item{genome}{
The genome assembly to use. The default is the most recent human genome assembly on the UCSC Genome Browser.
}
  \item{recombRateLocation}{
The plot distance from the LD heat map gene map.
}
  \item{view}{
Display mode. Possible values are \code{"dense"} (the default), \code{"squish"},
\code{"pack"} and \code{"full"}.
}
}
\value{
An object of class LDheatmap given as an argument, with the \code{grob}
\code{LDheatmapGrob} modified to inclue the \code{"recombRate"} child grob.
}
\references{
\url{http://genome.ucsc.edu/cgi-bin/hgTrackUi?g=recombRate}
}
\author{
Sigal Blay <sblay@sfu.ca>
}
\seealso{
\code{\link{LDheatmap}}, \code{\link{recombRate}}
}
\examples{
\dontrun{
data(GIMAP5.CEU) 
ll<-LDheatmap(GIMAP5.CEU$snp.data,GIMAP5.CEU$snp.support$Position,flip=TRUE)
# Add recombination rate plot
ll_recomb <- LDheatmap.addRecombRate(ll, chr="chr7", genome="hg18")
}
}
\keyword{ hplot }
