% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LEGIT.R
\name{IMLEGIT_net}
\alias{IMLEGIT_net}
\title{Independent Multiple Latent Environmental & Genetic InTeraction (IMLEGIT) model with Elastic Net on the latent variables. Do not use on it's own, use elastic_net_var_select instead.}
\usage{
IMLEGIT_net(data, latent_var, formula, latent_var_searched = NULL,
  cross_validation = FALSE, alpha = 1, lambda = 1e-04,
  start_latent_var = NULL, eps = 0.001, maxiter = 100,
  family = gaussian, ylim = NULL, cv_iter = 5, cv_folds = 10,
  folds = NULL, Huber_p = 1.345, classification = FALSE,
  print = TRUE, warn = TRUE, family_string = NULL)
}
\arguments{
\item{data}{data.frame of the dataset to be used.}

\item{latent_var}{list of data.frame. The elements of the list are the datasets used to construct each latent variable. For interpretability and proper convergence, not using the same variable in more than one latent variable is highly recommended. It is recommended to set names to the list elements to prevent confusion because otherwise, the latent variables will be named L1, L2, ... (See examples below for more details)}

\item{formula}{Model formula. The names of \code{latent_var} can be used in the formula to represent the latent variables. If names(\code{latent_var}) is NULL, then L1, L2, ... can be used in the formula to represent the latent variables. Do not manually code interactions, write them in the formula instead (ex: G*E1*E2 or G:E1:E2).}

\item{latent_var_searched}{Optional If not null, you must specify a vector containing all indexes of the latent variables you want to use elastic net on. Ex: If latent_var=list(G=genes, E=env), specifying latent_var_search=c(1,2) will use both, latent_var_search=1 will only do it for G, and latent_var_search=2 will only do it for E.}

\item{cross_validation}{If TRUE, will return cross-validation criterion (slower)}

\item{alpha}{The elasticnet mixing parameter (between 0 and 1). 1 leads to lasso, 0 leads to ridge. See glmnet package manual for more information. We recommend somewhere betwen .50 and 1.}

\item{lambda}{Lambda (penalty term for elastic net, see glmnet package manual) (Default = .0001)}

\item{start_latent_var}{Optional list of starting points for each latent variable (The list must have the same length as the number of latent variables and each element of the list must have the same length as the number of variables of the corresponding latent variable).}

\item{eps}{Threshold for convergence (.01 for quick batch simulations, .0001 for accurate results).}

\item{maxiter}{Maximum number of iterations.}

\item{family}{Outcome distribution and link function (Default = gaussian).}

\item{ylim}{Optional vector containing the known min and max of the outcome variable. Even if your outcome is known to be in [a,b], if you assume a Gaussian distribution, predict() could return values outside this range. This parameter ensures that this never happens. This is not necessary with a distribution that already assumes the proper range (ex: [0,1] with binomial distribution).}

\item{cv_iter}{Number of cross-validation iterations (Default = 5).}

\item{cv_folds}{Number of cross-validation folds (Default = 10). Using \code{cv_folds=NROW(data)} will lead to leave-one-out cross-validation.}

\item{folds}{Optional list of vectors containing the fold number for each observation. Bypass cv_iter and cv_folds. Setting your own folds could be important for certain data types like time series or longitudinal data.}

\item{Huber_p}{Parameter controlling the Huber cross-validation error (Default = 1.345).}

\item{classification}{Set to TRUE if you are doing classification (binary outcome).}

\item{print}{If FALSE, nothing except warnings will be printed. (Default = TRUE).}

\item{warn}{If FALSE, it will not show warnings when all variables inside a latent variable are removed. This serves to prevent lots of warning when running elastic_net_var_select (Default = TRUE).}

\item{family_string}{Optional String version of the family (gaussian leads to "gaussian"). This is only needed when using elastic_net_var_select. Please ignore this.}
}
\value{
Returns a list containing, in the following order: a IMLEGIT model, the coefficients of the variables in the latent variables from glmnet models, and the cross-validation results (if asked).
}
\description{
Constructs a generalized linear model (glm) with latent variables using alternating optimization. This is an extension of the LEGIT model to accommodate more than 2 latent variables. Note that, as opposed to LEGIT/IMLEGIT, the parameters of variables inside the latent variables are not L1-normalized; instead, its the main model parameters which are L1-normalized. This is needed to make elastic net works. It doesn't matter in the end, because we only care about which variables were removed and we only give the IMLEGIT models without elastic net penalization.
}
\references{
Alexia Jolicoeur-Martineau, Ashley Wazana, Eszter Szekely, Meir Steiner, Alison S. Fleming, James L. Kennedy, Michael J. Meaney, Celia M.T. Greenwood and the MAVAN team. \emph{Alternating optimization for GxE modelling with weighted genetic and environmental scores: examples from the MAVAN study} (2017). arXiv:1703.08111.
}
