% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AQSysTern.R
\name{AQSysTern}
\alias{AQSysTern}
\title{This functions plot a ternary plot based in the chosen model and its parameters.}
\usage{
AQSysTern(XYdt, color = "black", shape = 1, title = NULL, style = "bw",
  wlabel = "(\%, m/m)", xlbl = "X", ylbl = "Y", zlbl = "Z",
  tcolor = "red2", lcolor = "darkgoldenrod2", rcolor = "blue4",
  x_arrow_lbl = xlbl, y_arrow_lbl = ylbl, z_arrow_lbl = zlbl,
  HR = FALSE, silent = FALSE, save = silent, single = TRUE,
  wdir = NULL, filename = NULL, series = NULL, ltitle = NULL)
}
\arguments{
\item{XYdt}{Binodal Experimental data that will be used in the nonlinear fit. [type::data.frame]}

\item{color}{Set data point's color. All color's names R knows about can be found in \code{\link[grDevices]{colors}}. [type:string]}

\item{shape}{Set of aesthetic mappings created by \code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_}}.}

\item{title}{Plot's Title. Default is NULL, for no title. [type:string]}

\item{style}{Plot's Style.}

\item{wlabel}{Label on ternary arrows. [type:string]}

\item{xlbl}{Plot's Bottom-enriched Component axis label. [type:string]}

\item{ylbl}{Plot's Upper-enriched Component axis label. [type:string]}

\item{zlbl}{Plot's Water Fraction axis label. [type:string]}

\item{tcolor}{T axis color. [type:string]}

\item{lcolor}{L axis color. [type:string]}

\item{rcolor}{R axis color. [type:string]}

\item{x_arrow_lbl}{Plot's Bottom-enriched Component arrow label. [type:string]}

\item{y_arrow_lbl}{Plot's Upper-enriched Component arrow label. [type:string]}

\item{z_arrow_lbl}{Plot's Water Fraction arrow label. [type:string]}

\item{HR}{Magnify Plot's text to be compatible with High Resolution size [type:Boulean]}

\item{silent}{Perform functions taks without returning variables or requesting Input. If TRUE, wdir and filename are mandatory. [type:Boulean]}

\item{save}{Magnify Plot's text to be compatible with High Resolution size [type:Boulean]}

\item{single}{TRUE if a single series will be plot and FALSE if otherwise. If FALSE, series variable must be provided. [type:Boulean]}

\item{wdir}{Set working directory in which plot's file will be saved. Set as "" to save in the current working directory. [type:string]}

\item{filename}{Set a name for the plot's file. [type:string]}

\item{series}{A data.frame containin series names in the first columns and its respective colors in the second column. [type:data.frame]}

\item{ltitle}{plot's legend title. [type:string]}
}
\value{
A ternary plot using the input model within the chosen interval and the curve's raw XY data.
}
\description{
The function returns a ternary plot after using the parameters and model given by the user.
}
\details{
The function have predefined set of equations that can be seen below and must be used, with adequated parameters,
to return a plot which represent the chosen model.
}
\examples{
\dontrun{
AQSysTern(peg4kslt[1:2])
}
}

