% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AQSearch.R
\name{AQSearch}
\alias{AQSearch}
\alias{AQSearch.default}
\title{Search function for ATPS Systems data}
\usage{
AQSearch(db = LLSR::llsr_data, db.ph = NULL, db.upper = NULL,
  db.lower = NULL, db.temp = NULL, db.additive = NULL, ...)

\method{AQSearch}{default}(db = LLSR::llsr_data, db.ph = NULL,
  db.upper = NULL, db.lower = NULL, db.temp = NULL,
  db.additive = NULL, ...)
}
\arguments{
\item{db}{A highly structure db containing data from previously analised data. LLSR database is used by default but user may input his own db if formatted properly.}

\item{db.ph}{A numeric variable containing the pH to be searched within DB.}

\item{db.upper}{A String variable containing either the CAS, chemical formula or name of the upper phase enriched component..}

\item{db.lower}{A String variable containing either the CAS, chemical formula or name of the lower phase component.}

\item{db.temp}{A numeric variable containing the Temperature (in Kelvin) to be searched within DB.}

\item{db.additive}{A String variable containing either the CAS, chemical formula or name of the additive component.}

\item{...}{Additional optional arguments. None are used at present.}
}
\value{
Returns a data.frame containing system's parameters which match searched conditions
}
\description{
This function allow the user to search the LLSR database to find any ATPS that matches the used criteria.

This function allow the user to search the package database to find any ATPS that matches the used criteria.
}
\details{
The function return the systems that matches the criteria submit by the user.
}
\examples{
\dontrun{
AQSearch(db.upper="85100-78-3")
}
}
