% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LMMsolve-class.R
\name{predict.LMMsolve}
\alias{predict.LMMsolve}
\title{Predict function}
\usage{
\method{predict}{LMMsolve}(object, ..., newdata, se.fit = FALSE)
}
\arguments{
\item{object}{an object of class LMMsolve.}

\item{...}{Unused.}

\item{newdata}{A data.frame containing new points for which the smooth
trend should be computed. Column names should include the names used when
fitting the spline model.}

\item{se.fit}{calculate standard errors, default \code{FALSE}.}
}
\value{
A data.frame with predictions for the smooth trend on the specified
grid. The standard errors are saved if `se.fit=TRUE`.
}
\description{
Predict function
}
\examples{
## simulate some data
f <- function(x) { 0.3 + 0.4*x + 0.2*sin(20*x) }
set.seed(12)
n <- 150
x <- seq(0, 1, length = n)
sigma2e <- 0.04
y <- f(x) + rnorm(n, sd = sqrt(sigma2e))
dat <- data.frame(x, y)

## fit the model
obj <- LMMsolve(fixed = y ~ 1,
         spline = ~spl1D(x, nseg = 50), data = dat)

## make predictions on a grid
newdat <- data.frame(x = seq(0, 1, length = 300))
pred <- predict(obj, newdata = newdat, se.fit = TRUE)
head(pred)

}
