% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot}
\alias{autoplot}
\alias{autoplot.lmm}
\title{Graphical Display For Linear Mixed Models}
\usage{
\method{autoplot}{lmm}(
  object,
  obs.alpha = 0,
  obs.size = c(2, 0.5),
  at = NULL,
  color = TRUE,
  ci = TRUE,
  ci.alpha = NA,
  plot = TRUE,
  mean.size = c(3, 1),
  size.text = 16,
  position.errorbar = "identity",
  ...
)
}
\arguments{
\item{object}{a \code{lmm} object.}

\item{obs.alpha}{[numeric, 0-1] When not NA, transparency parameter used to display the original data by cluster.}

\item{obs.size}{[numeric vector of length 2] size of the point and line for the original data.}

\item{at}{[data.frame] values for the covariates at which to evaluate the fitted values.}

\item{color}{[character] name of the variable in the dataset used to color the curve.}

\item{ci}{[logical] should confidence intervals be displayed?}

\item{ci.alpha}{[numeric, 0-1] When not NA, transparency parameter used to display the confidence intervals.}

\item{plot}{[logical] should the plot be displayed?}

\item{mean.size}{[numeric vector of length 2] size of the point and line for the mean trajectory.}

\item{size.text}{[numeric, >0] size of the font used to displayed text when using ggplot2.}

\item{position.errorbar}{[character] relative position of the errorbars.}

\item{...}{arguments passed to the predict method.}
}
\value{
A list with two elements \itemize{
\item \code{data}: data used to create the graphical display.
\item \code{plot}: ggplot object.
}
}
\description{
Graphical Display For Linear Mixed Models
}
