% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure.R
\name{TOEPLITZ}
\alias{TOEPLITZ}
\title{Toeplitz Structure}
\usage{
TOEPLITZ(formula, var.cluster, var.time, heterogeneous = "LAG", add.time)
}
\arguments{
\item{formula}{formula indicating on which variable to stratify the residual variance and correlation (left hand side)
and variables influencing the residual variance and correlation (right hand side).}

\item{var.cluster}{[character] cluster variable.}

\item{var.time}{[character] time variable.}

\item{heterogeneous}{[character] degree of flexibility of the correlation structure within covariate (\code{"UN","LAG","CS"}).
Will also affect the variance structure when not explicit.}

\item{add.time}{Should the default formula (i.e. when \code{NULL}) contain a time effect.}
}
\value{
An object of class \code{TOEPLITZ} that can be passed to the argument \code{structure} of the \code{lmm} function.
}
\description{
Variance-covariance structure for stationnary processes.
Can be stratified on a categorical variable.
}
\details{
\bold{formula}: there can only be at most one covariate for the correlation structure.
A typical formula would be \code{~1}, indicating a variance constant over time and a correlation specific to each gap time.

\bold{heterogeneous}: for a binary covariate the correlation matrix can be decomposed into four blocs: A, B, B, C.
A correspond the correlation within level 0 of the covariate, C within level 1, and B between level 0 and 1.
Different correlation structures can be specified:\itemize{ 
\item \code{"UN"}: unstructured matrix except for the diagonal elements of C which are constrained to be equal.
\item \code{"LAG"}: Toeplitz structure within A, B, and C, i.e. correlation specific to each time lag and covariate level.
\item \code{"CS"}: block-specific value except for C which has a different value for its diagonal elements.
}
}
\examples{
## no covariate
TOEPLITZ(~1, var.cluster = "id", var.time = "time")
TOEPLITZ(gender~1, var.cluster = "id", var.time = "time")
TOEPLITZ(list(~time,~1), var.cluster = "id", var.time = "time")
TOEPLITZ(list(gender~time,gender~1), var.cluster = "id", var.time = "time")

## with covariates
TOEPLITZ(~1, var.cluster = "id", heterogeneous = "UN",
         var.time = "time", add.time = c("time","side"))
TOEPLITZ(~1, var.cluster = "id", heterogeneous = "LAG",
         var.time = "time", add.time = c("time","side"))
TOEPLITZ(~1, var.cluster = "id", heterogeneous = "CS",
         var.time = "time", add.time = c("time","side"))
TOEPLITZ(gender~1, var.cluster = "id", heterogeneous = "CS",
         var.time = "time", add.time = c("time","side"))
}
