% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate.R
\name{estimate.lmm}
\alias{estimate.lmm}
\title{Delta Method for Mixed Models}
\usage{
\method{estimate}{lmm}(
  x,
  f,
  df = !is.null(x$df),
  robust = FALSE,
  type.information = NULL,
  level = 0.95,
  method.numDeriv = NULL,
  average = FALSE,
  transform.sigma = NULL,
  transform.k = NULL,
  transform.rho = NULL,
  ...
)
}
\arguments{
\item{x}{a \code{lmm} object.}

\item{f}{[function] function of the model coefficient computing the parameter(s) of interest. Can accept extra-arguments.}

\item{df}{[logical] Should degree of freedom, computed using Satterthwaite approximation, for the parameter of interest be output.}

\item{robust}{[logical] Should robust standard errors (aka sandwich estimator) be output instead of the model-based standard errors.}

\item{type.information}{[character] Should the expected information be used  (i.e. minus the expected second derivative) or the observed inforamtion (i.e. minus the second derivative).}

\item{level}{[numeric,0-1] the confidence level of the confidence intervals.}

\item{method.numDeriv}{[character] method used to approximate the gradient: either \code{"simple"} or \code{"Richardson"}.
Passed to \code{numDeriv::jacobian}.}

\item{average}{[logical] is the estimand the average output of argument \code{f}?
Otherwise consider each individual output of argument \code{f}.}

\item{transform.sigma}{[character] Transformation used on the variance coefficient for the reference level. One of \code{"none"}, \code{"log"}, \code{"square"}, \code{"logsquare"} - see details.}

\item{transform.k}{[character] Transformation used on the variance coefficients relative to the other levels. One of \code{"none"}, \code{"log"}, \code{"square"}, \code{"logsquare"}, \code{"sd"}, \code{"logsd"}, \code{"var"}, \code{"logvar"} - see details.}

\item{transform.rho}{[character] Transformation used on the correlation coefficients. One of \code{"none"}, \code{"atanh"}, \code{"cov"} - see details.}

\item{...}{extra arguments passed to \code{f}.}
}
\description{
Perform a first order delta method
}
\examples{
if(require(lava)){

#### Random effect ####
set.seed(10)
dL <- sampleRem(1e2, n.times = 3, format = "long")
e.lmm1 <- lmm(Y ~ X1+X2+X3, repetition = ~visit|id, structure = "CS", data = dL)
coef(e.lmm1, effects = "ranef")
e.ranef <- estimate(e.lmm1, f  = function(p){coef(e.lmm1, p = p, effects = "ranef")})
e.ranef

if(require(ggplot2)){
df.gg <- cbind(index = 1:NROW(e.ranef), e.ranef)
gg.ranef <- ggplot(df.gg, aes(x = index, y=estimate, ymin=lower, ymax = upper))
gg.ranef + geom_point() + geom_errorbar() + ylab("estimated random effect") + xlab("id")
}

#### ANCOVA via mixed model ####
set.seed(10)
d <- sampleRem(1e2, n.time = 2)
e.ANCOVA1 <- lm(Y2~Y1+X1, data = d)

if(require(reshape2)){
   dL2 <- melt(d, id.vars = c("id","Y1","X1"),  measure.vars = c("Y1","Y2"))
   e.lmm <- lmm(value ~ variable + variable:X1, data = dL2, repetition = ~variable|id)

   e.delta <- estimate(e.lmm, function(p){
       c(Y1 = p["rho(Y1,Y2)"]*p["k.Y2"],
         X1 = p["variableY2:X1"]-p["k.Y2"]*p["rho(Y1,Y2)"]*p["variableY1:X1"])
})
   ## same estimate and similar standard errors. 
   e.delta
   summary(e.ANCOVA1)$coef
   ## Degrees of freedom are a bit off though
}

}
}
