% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParallelTestEM.R
\name{ParallelTestEM}
\alias{ParallelTestEM}
\title{ECME-based testing for a Pareto tail}
\usage{
ParallelTestEM(nboot, y, obsTest)
}
\arguments{
\item{nboot}{number of bootstrap replications.}

\item{y}{observed data.}

\item{obsTest}{value of the test statistics computed with the data under analysis.}
}
\value{
A list with the following elements:

LR: nboot simulated values of the llr test under the null hypothesis.

pval: p-value of the test.
}
\description{
This function computes the bootstrap test for the null hypothesis of
a pure lognormal distribution versus the alternative of a lognormal-Pareto
mixture, where the parameters of the latter are estimated by means of the
ECME algorithm.
likelihood. Implemented via parallel computing.
}
\examples{
\donttest{minRank = 90
mixFit <- LPfitEM(TN2016,1e-12,1000)
ell1 <- mixFit$loglik
estNull <- c(mean(log(TN2016)),sd(log(TN2016)))
ellNull <- sum(log(dlnorm(TN2016,estNull[1],estNull[2])))
obsTest <- 2*(ell1-ellNull)
nboot = 2
TestRes = ParallelTestEM(nboot,TN2016,obsTest)}
}
