% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotStrategybyCatPerformance_m2.R
\name{PlotStrategybyCatPerformance}
\alias{PlotStrategybyCatPerformance}
\title{Check response time by var}
\usage{
PlotStrategybyCatPerformance(data, strategy.var, categ.var, namexlab,
  nameylab)
}
\arguments{
\item{data}{A \code{matrix} or \code{data.frame}}

\item{strategy.var}{strategy variable}

\item{categ.var}{categorizing variable}

\item{namexlab}{name of the variable in the x-axis}

\item{nameylab}{name of the variable in the y-axis}
}
\value{
This function returns a \code{data.frame} with the number of students
  and number de actions (min-max) aggregated by a specific variable.
}
\description{
This is a function that reports the number of students and number of actions
(min-max) aggregated by a specific variable.
}
\examples{
# Data preparation
df <- cp025q01.treated
df$categ <- cut(df$PV1CPRO, c(0, 423, 488, 553, 900))
df.dataplot <- df[, c("top", "categ")]
df.dataplot[,1] <- as.factor(df.dataplot[,1])
df.dataplot[,2] <- as.factor(df.dataplot[,2])

# Function demonstration
m2$PlotStrategybyCatPerformance(df.dataplot, top, categ,
                                 "Proficiency levels", "Percentage")

}
