% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10_LNS.R
\name{LNScaling}
\alias{LNScaling}
\title{LNScaling}
\usage{
LNScaling(EFTs = NULL, ProdVar = NULL, cores2use = 1, filename = "")
}
\arguments{
\item{EFTs}{RasterLayer object (or its file name). Ecosystem Functional Types. Its first variable has the number of EFT (cluster) each pixel belongs to}

\item{ProdVar}{Raster* object (or its file name). Productivity variable (e.g. Cyclic fraction -season growth-)}

\item{cores2use}{Numeric. Number of cores to use for parallelization. Optional. Default is 1 (no parallelization)}

\item{filename}{Character. Output filename. Optional}
}
\value{
RasterLayer object
}
\description{
LNScaling (Local Net Productivity Scaling) uses a productivity variable
(Raster*), e.g. season growth, to calculate the actual status of land productivity
relative to its potential in homogeneous land areas or Ecosystem Functional Types
(RasterLayer). If the productivity variable 'ProdVar' is a RasterStack or RasterBrick
object with time series, it is calculated the average of the last 5 years
}
\details{
The Local Net Primary Production Scaling (LNS) method (Prince, 2009) calculates
 the difference between the potential and actual Net Primary Production for each pixel
 in homogeneous land areas. The current land production related to the local potential
 reflects the current level of productivity efficiency and, therefore, it is useful for
 the delineation of a land productivity status map
}
\examples{
\donttest{
dirctry <- paste0(system.file(package='LPDynR'), "/extdata")
variables_noCor <- rm_multicol(dir2process = dirctry,
                               multicol_cutoff = 0.7)
EFTs_raster <- EFT_clust(obj2clust = variables_noCor,
                         n_clust = 10)
sb <- raster::brick(paste0(system.file(package='LPDynR'), "/extdata/sb_cat.tif"))

LNScaling(EFTs = EFTs_raster[[1]],
          ProdVar = sb)
}

}
\references{
Prince, S.D., Becker-Reshef, I. and Rishmawi, K. 2009. “Detection and Mapping of Long-Term Land Degradation Using Local Net Production Scaling: Application to Zimbabwe.” REMOTE SENSING OF ENVIRONMENT 113 (5): 1046–57
}
\seealso{
\code{\link{EFT_clust}}
}
\author{
Xavier Rotllan-Puig
}
