% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/negative_binomial_tests.R
\name{negative_binomial_p_one_way}
\alias{negative_binomial_p_one_way}
\title{Test the equality of p parameters of negative binomial distributions.}
\source{
\itemize{
\item \url{https://en.wikipedia.org/wiki/Likelihood-ratio_test}
\item Yudi Pawitan. In All Likelihood. Oxford University Press.
\item Hodd, McKean, and Craig. Introduction to Mathematical Statistics. Pearson.
}
}
\usage{
negative_binomial_p_one_way(
  num_failures,
  num_successes,
  fctr,
  conf.level = 0.95
)
}
\arguments{
\item{num_failures}{a numeric vector indicating number of failures per group.}

\item{num_successes}{a numeric vector indicating number of successes per group.}

\item{fctr}{a factor vector indicating groups.}

\item{conf.level}{overall confidence level of the likelihood intervals. Uses Bonferroni correction.}
}
\value{
An S3 class containing the test statistic, p value, list of likelihood based confidence intervals,
overall confidence level, individual confidence level of each interval and alternative
hypothesis.
}
\description{
Test the equality of p parameters of negative binomial distributions.
}
\examples{
library(LRTesteR)

# Null is true.
set.seed(1)
num_failures <- rnbinom(3, 50, .5)
num_successes <- rep(50, length(num_failures))
fctr <- factor(1:length(num_failures))
negative_binomial_p_one_way(num_failures, num_successes, fctr, .95)


# Null is false
set.seed(1)
num_failures <- rnbinom(3, 50, c(.25, .50, .75))
num_successes <- rep(50, length(num_failures))
fctr <- factor(1:length(num_failures))
negative_binomial_p_one_way(num_failures, num_successes, fctr, .95)
}
