% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{smooth_lss}
\alias{smooth_lss}
\title{Smooth predicted polarity scores}
\usage{
smooth_lss(
  x,
  lss_var = "fit",
  date_var = "date",
  span = 0.1,
  group = NULL,
  from = NULL,
  to = NULL,
  by = "day",
  engine = c("loess", "locfit"),
  ...
)
}
\arguments{
\item{x}{a \link{data.frame} containing polarity scores and dates.}

\item{lss_var}{the name of the column in \code{x} for polarity scores.}

\item{date_var}{the name of the column in \code{x} for dates.}

\item{span}{the level of smoothing.}

\item{group}{the name of the column in \code{x} to smooth the data by group.}

\item{from, to, by}{the the range and the internal of the smoothed scores;
passed to \link{seq.Date}.}

\item{engine}{specifies the function to be used for smoothing.}

\item{...}{additional arguments passed to the smoothing function.}
}
\description{
Smooth predicted polarity scores by local polynomial regression.
}
\details{
Smoothing is performed using \code{\link[stats:loess]{stats::loess()}} or \code{\link[locfit:locfit]{locfit::locfit()}}.
When the \code{x} has more than 10000 rows, it is usually better to choose
the latter by setting \code{engine = "locfit"}. In this case, \code{span} is passed to
\code{locfit::lp(nn = span)}.
}
