% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step3_est.R
\name{step3.est}
\alias{step3.est}
\title{Step 3 estimation for latent logistic regression coefficients}
\usage{
step3.est(
  cep,
  z_t1,
  z_t2,
  K,
  t,
  beta_in = matrix(0, ncol(z_t1), K),
  ga01_in = matrix(0, ncol(z_t2), K),
  ga10_in = matrix(0, ncol(z_t2))
)
}
\arguments{
\item{cep}{estimated classification error probabilities returned from \code{\link{CEP_t}}. The uncorrected attribute profile (EAP) is also stored in this object.}

\item{z_t1}{covariates at Time 1, which has already had the intercept column (1s).}

\item{z_t2}{covariates at Time 2, which has already had the intercept column (1s).}

\item{K}{the number of attributes.}

\item{t}{the number of time points. This package can only handle two time points can for the time being.}

\item{beta_in}{the initial values for the regression coefficients at Time 1 (initial state). Default are 0s.}

\item{ga01_in}{the initial values for the regression coefficients of transition from absence (0) to presence (1) at Time 2. Default are 0s.}

\item{ga10_in}{the initial values for the regression coefficients of transition from presence (1) to absence (0) at Time 2. Default are 0s.}
}
\value{
a list with elements
\describe{
\item{beta}{A data frame with 2 rows and 4 columns, representing the estimated regression coefficients at Time 1 (initial state)}
\item{gamma_01}{A data frame with 4 rows and 4 columns, representing the estimated regression coefficients of transition from absence (0) to presence (1) at Time 2}
\item{gamma_10}{A data frame with 4 rows and 4 columns, representing the estimated regression coefficients of transition from absence (0) to presence (1) at Time 2}
\item{result}{A data frame with dimensions 40 by 9, containing the results of the estimation, including all regression coefficients and the corresponding odds ratios, Cohen's d, standard errors (SE), 95\% confidence intervals, and p-values.}
}
}
\description{
Step 3 estimation for latent logistic regression coefficients
}
\examples{
t = 2 # the number of time points
K = ncol(Q) # the number of attributes
z_t1_test = matrix(sample(c(0, 1), size = 20, replace = TRUE), nrow = 10)
z_t2_test = matrix(sample(c(0, 1), size = 40, replace = TRUE), nrow = 10)
# Set appropriate initial values of the coefficients
# Initial values of initial state's regression coefficients
beta_in = matrix(0, ncol(z_t1_test), K)

# Initial values of transition probability's regression coefficients
# These were computed using the raw data.
# When Gender coding is 1 = male, 0 = female:
ga01_in = cbind(c(-2.15, 0.56, 0.09, -0.79),
                c(-1.6, 0.05, -0.01, -0.38),
                c(-1.25, 0.06, -0.25, 0.14),
                c(-1.18, -0.26, 0.04, 0.37))
                #initial values of regression coefficients (for transition from 0 to 1)
ga10_in = cbind(c(-0.84, -0.18, -0.14, 0.23),
                c(-0.18, 0.49, 0.44, -0.35),
                c(-0.22, 0.18, 0.37, -0.45),
                c(-0.49, 0.10, 0.43, 0.20))
cep_test = list()
cep_test[["mp"]][[1]] = matrix(runif(40,min = 0,max=1),nrow = 10)
cep_test[["mp"]][[2]] = matrix(runif(40,min = 0,max=1),nrow = 10)
cep_test[["eap"]][[1]] = matrix(runif(40,min = 0,max=1),nrow = 10)
cep_test[["eap"]][[2]] = matrix(runif(40,min = 0,max=1),nrow = 10)
for (i in 1:4){
cep_test[["cep_matrix"]][[i]]=list()
cep_test[["w"]][[i]]=list()
for (k in 1:2) {
  cep_test[["cep_matrix"]][[i]][[k]]=matrix(c(1,0.02,0.06,1),nrow = 2)
      cep_test[["w"]][[i]][[k]] = matrix(runif(20,min = 0,max=1),nrow = 10)
        }
       }
step3.output_test <- step3.est(cep = cep_test, z_t1 = z_t1_test, z_t2 = z_t2_test,
 K = K, t = t, beta_in, ga01_in, ga10_in)
\dontrun{
# The run is dependent on the output of the CEP_t() function
# And the process time takes more than 5s.
# It is not recommended to run it.
# Covariates
Z = dat1[, c(1,2)] # use intervention and gender as covariates
z_t1 = cbind(1, Z$gender)  # Covariate at time 1
z_t2 = cbind(1, Z$gender, Z$intervention, apply(Z,1,prod)) # Covariates at time 2
colnames(z_t1) <- c("intercept", "gender")
colnames(z_t2) <- c("intercept", "gender", "intervention", "intervention_gender")

t = 2 # the number of time points
K = ncol(Q) # the number of attributes

# Set appropriate initial values of the coefficients
# Initial values of initial state's regression coefficients
beta_in = matrix(0, ncol(z_t1), K)

# Initial values of transition probability's regression coefficients
# These were computed using the raw data.
# When Gender coding is 1 = male, 0 = female:
ga01_in = cbind(c(-2.15, 0.56, 0.09, -0.79),
                c(-1.6, 0.05, -0.01, -0.38),
                c(-1.25, 0.06, -0.25, 0.14),
                c(-1.18, -0.26, 0.04, 0.37))
                #initial values of regression coefficients (for transition from 0 to 1)
ga10_in = cbind(c(-0.84, -0.18, -0.14, 0.23),
                c(-0.18, 0.49, 0.44, -0.35),
                c(-0.22, 0.18, 0.37, -0.45),
                c(-0.49, 0.10, 0.43, 0.20))
                #initial values of regression coefficients (for transition from 1 to 0)
# Step 3 estimation (This will take a few minutes)
step3.output <- step3.est(cep = cep, z_t1 = z_t1, z_t2 = z_t2, K = K,
                          t = t, beta_in = beta_in, ga01_in = ga01_in, ga10_in = ga10_in)

# Obtain estimation results
step3.output$result

# Latent logistic regression coefficients
beta = step3.output$beta
gamma_01 = step3.output$gamma_01
gamma_10 = step3.output$gamma_10
}
}
