% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sem_lucid.R
\name{sem_lucid}
\alias{sem_lucid}
\title{SEM for latent cluster estimation}
\usage{
sem_lucid(G = NULL, Z = NULL, Y, family = "binary", useY = TRUE,
  K = 2, initial = def_initial(), itr_tol = def_tol(),
  Pred = FALSE, Get_SE = TRUE, Ad_Hoc_SE = FALSE)
}
\arguments{
\item{G}{Genetic effects, a matrix}

\item{Z}{Biomarker data, a matrix}

\item{Y}{Disease outcome, a vector}

\item{family}{"binary" or "normal" for Y}

\item{useY}{Using Y or not, default is TRUE}

\item{K}{Pre-specified # of latent clusters, default is 2}

\item{initial}{A list of initial model parameters will be returned for integrative clustering}

\item{itr_tol}{A list of tolerance settings will be returned for integrative clustering}

\item{Pred}{Flag to compute predicted disease probability with fitted model, boolean, default is FALSE}

\item{Get_SE}{Flag to perform SEM to get SEs of parameter estimates, default is TRUE}

\item{Ad_Hoc_SE}{Flag to fit ad hoc regression models to get SEs of parameter estimates, default is FALSE}
}
\value{
\code{sem_lucid} returns an object of list containing parameters estimates, their corresponding standard errors, and other features:
\item{beta}{Estimates of genetic effects, matrix}
\item{se_beta}{SEM standard errors of Beta}
\item{se_ah_beta}{Ad hoc standard errors of Beta}
\item{mu}{Estimates of cluster-specific biomarker means, matrix}
\item{se_mu}{SEM standard errors of Mu}
\item{se_ah_mu}{Ad hoc standard errors of Mu}
\item{sigma}{Estimates of cluster-specific biomarker covariance matrix, list}
\item{gamma}{Estimates of cluster-specific disease risk, vector}
\item{se_gamma}{SEM standard errors of Gamma}
\item{se_ah_gamma}{Ad hoc standard errors of Gamma}
\item{pcluster}{Probability of cluster, when G is null}
\item{pred}{Predicted probability of belonging to each latent cluster}
}
\description{
\code{sem_lucid} provides standard errors (SE) of parameter estimates when performing latent cluster analysis with multi-omics data. SEs are obtained through supplemented EM-algorithm (SEM).
}
\examples{
\dontrun{
sem_lucid(G=G2,Z=Z2,Y=Y2,useY=TRUE,K=2,Pred=TRUE,family="normal",Get_SE=TRUE,
            itr_tol = def_tol(MAX_ITR=1000,MAX_TOT_ITR=3000))
}
}
\references{
Meng, X., & Rubin, D. B. (1991). Using EM to Obtain Asymptotic Matrices : The SEM Algorithm. Journal of the American Statistical Association, 86(416), 899-909. http://doi.org/10.2307/2290503

Peng, C., Conti, D.V., Integrative latent cluster assignment using multi-omics data with phenotypic traits (under preparation).
}
\author{
Cheng Peng, Zhao Yang, David V. Conti
}
\keyword{SEM,}
\keyword{cluster}
\keyword{latent}
