% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune_lucid.R
\name{tune_lucid}
\alias{tune_lucid}
\title{Parallel Grid Search for Tuning Parameters in Latent Cluster Analysis}
\usage{
tune_lucid(
  G = NULL,
  CoG = NULL,
  Z = NULL,
  CoY = NULL,
  Y,
  K,
  Family,
  USEY = TRUE,
  initial = def_initial(),
  LRho_g,
  URho_g,
  NoRho_g,
  LRho_z_invcov,
  URho_z_invcov,
  NoRho_z_invcov,
  LRho_z_covmu,
  URho_z_covmu,
  NoRho_z_covmu,
  NoCores = detectCores() - 1
)
}
\arguments{
\item{G}{Genetic features, a matrix}

\item{CoG}{Covariates to be added in G->X path}

\item{Z}{Biomarker data, a matrix}

\item{CoY}{Covariates to be added in X->Y path}

\item{Y}{Disease outcome, a vector}

\item{K}{Pre-specified # of latent clusters}

\item{Family}{"binary" or "normal" for Y}

\item{USEY}{Using Y or not, default is TRUE}

\item{initial}{A list of initial model parameters will be returned for integrative clustering}

\item{LRho_g}{Lower limit of the penalty for selection on genetic data}

\item{URho_g}{Upper limit of the penalty for selection on genetic data}

\item{NoRho_g}{Number of \code{Rho_g} for grid-search}

\item{LRho_z_invcov}{Lower limit of the penalty for the inverse of covariance of biomarkers}

\item{URho_z_invcov}{Upper limit of the penalty for the inverse of covariance of biomarkers}

\item{NoRho_z_invcov}{Number of \code{Rho_z_invcov} for grid-search}

\item{LRho_z_covmu}{Lower limit of the penalty for the product of covariance and mean of biomarkers}

\item{URho_z_covmu}{Upper limit of the penalty for the product of covariance and mean of biomarkers}

\item{NoRho_z_covmu}{Number of \code{Rho_z_covmu} for grid-search}

\item{NoCores}{Number of CPU cores for parallel grid-search, default is total number of cores minus 1}
}
\value{
\code{tune_lucid} returns an object of list containing Modelfits, Results, and Optimal:
\item{Modelfits}{Latent cluster model fits for a combination of given tuning parameters}
\item{Results}{Summary results of grid-search}
\item{Optimal}{Features of the optimal model with minimum BIC in the grid-search summary}
}
\description{
\code{tune_lucid} fits regularized latent cluster models with various combinations of three tuning parameters based on joint inference across data types to perform a grid-search helping determine an optimal choice of three tuning parameters with minimum model BIC.
}
\examples{
# For a testing dataset with 10 genetic features (5 causal) and 4 biomarkers (2 causal)
# Parallel grid-search with 8 combinations of tuning parameters
\dontrun{
GridSearch <- tune_lucid(G=G1, Z=Z1, Y=Y1, K=2, Family="binary", USEY = TRUE, NoCores = 2,
                         LRho_g = 0.008, URho_g = 0.012, NoRho_g = 2,
                         LRho_z_invcov = 0.04, URho_z_invcov = 0.06, NoRho_z_invcov = 2,
                         LRho_z_covmu = 90, URho_z_covmu = 100, NoRho_z_covmu = 2)
GridSearch$Results
# Determine the best tuning parameters
GridSearch$Optimal
}
}
\references{
Cheng Peng, Jun Wang, Isaac Asante, Stan Louie, Ran Jin, Lida Chatzi, Graham Casey, Duncan C Thomas, David V Conti, A Latent Unknown Clustering Integrating Multi-Omics Data (LUCID) with Phenotypic Traits, Bioinformatics, , btz667, https://doi.org/10.1093/bioinformatics/btz667.
}
\author{
Cheng Peng, Zhao Yang, David V. Conti
}
\keyword{Grid-search}
\keyword{Parameter}
\keyword{Tuning}
