% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_lucid.R
\name{summary.lucid}
\alias{summary.lucid}
\title{Summarize the results of LUCID model}
\usage{
\method{summary}{lucid}(object, boot.se = NULL, ...)
}
\arguments{
\item{object}{A model fitted by \code{\link{est.lucid}}}

\item{boot.se}{A object returned by \code{\link{boot.lucid}}, which contains the bootstrap standard error}

\item{...}{Other parameters to be passed to \code{summary}}
}
\value{
A list with class "sumlucid", which contains the following object
\item{Beta}{Estimates of genetic/environmental effects (and effect of covariates if included), matrix}
\item{Mu}{Estimates of cluster-specific biomarker means, matrix}
\item{Gamma}{Estimates of cluster-specific disease risk (and effect of covariates if included), vector}
\item{Family}{Type of Y, binary or normal}
\item{K}{Number of latent clusters}
\item{loglik}{log likelihood of the model}
\item{BIC}{Bayesian Information Criteria of the model}
\item{boot.se}{Bootstrap SE for estimates, an object returned by \code{\link{boot.lucid}}}
}
\description{
Summarize the results of LUCID model
}
\examples{
\dontrun{
fit1 <- est.lucid(G = G1, Z = Z1, Y = Y1, CoY = CovY, K = 2, family = "binary", useY = FALSE)
summary(fit1)
fit2 <- est.lucid(G = G1, Z = Z1, Y = Y1, CoY = CovY, K = 2, family = "binary", useY = FALSE,
 tune = def.tune(Select_Z = TRUE, Rho_Z_InvCov = 0.1, Rho_Z_CovMu = 90, 
 Select_G = TRUE, Rho_G = 0.02)) 
summary(fit2)
}
}
\references{
Cheng Peng, Jun Wang, Isaac Asante, Stan Louie, Ran Jin, Lida Chatzi, Graham Casey, Duncan C Thomas, David V Conti, A Latent Unknown Clustering Integrating Multi-Omics Data (LUCID) with Phenotypic Traits, Bioinformatics, , btz667, https://doi.org/10.1093/bioinformatics/btz667.
}
\author{
Yinqi Zhao, Cheng Peng, Zhao Yang, David V. Conti
}
