% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LVGP_fit.R
\name{LVGP_fit}
\alias{LVGP_fit}
\title{The Fitting Function of \code{LVGP} Package}
\usage{
LVGP_fit(X, Y, ind_qual = NULL, dim_z = 2, eps = 10^(seq(-1, -8,
  length.out = 15)), lb_phi_ini = -2, ub_phi_ini = 2,
  lb_phi_lat = -8, ub_phi_lat = 3, lb_z = -3, ub_z = 3,
  n_opt = 8, max_iter_ini = 100, max_iter_lat = 20, seed = 123,
  progress = FALSE, parallel = FALSE, noise = FALSE)
}
\arguments{
\item{X}{Matrix or data frame containing the inputs of training data points. Each row is a data point.}

\item{Y}{Vector containing the outputs of training data points}

\item{ind_qual}{Vector containing the indices of columns of qualitative/categorical variables}

\item{dim_z}{Dimensionality of latent space, usually 1 or 2 but can be higher}

\item{eps}{The vector of smallest eigen values that the correlation matrix is allowed to have, which determines the nugget added to the correlation matrix.}

\item{lb_phi_ini, ub_phi_ini}{The initial lower and upper search bounds of the scale/roughness parameters (\code{phi}) of quantitative variables}

\item{lb_phi_lat, ub_phi_lat}{The later lower and upper search bounds of the scale/roughness parameters (\code{phi}) of quantitative variables}

\item{lb_z, ub_z}{The lower and upper search bounds of the latent parameters (\code{z}) of qualitative variables}

\item{n_opt}{The number of times the log-likelihood function is optimized}

\item{max_iter_ini}{The maximum number of iterations for each optimization run for largest (first) eps case}

\item{max_iter_lat}{The maximum number of iterations for each optimization run for after first eps cases}

\item{seed}{An integer for the random number generator. Use this to make the results reproducible.}

\item{progress}{The switch determining whether to print function run details}

\item{parallel}{The switch determining whether to use parallel computing}

\item{noise}{The switch for whether the data are assumed noisy}
}
\value{
A model of class "LVGP model" list of the following items:
\itemize{
\item{\code{quant_param}} {A list containing the estimated parameter \code{phi} and its search bounds for quantitative variables}
\item{\code{qual_param}} {A list containing the estimated parameter \code{z} and its dimensionality, vectorized form and search bounds for qualitative variables}
\item{\code{data}} {A list containing the fitted dataset in verbose format}
\item{\code{fit_detail}} {A list of more detailed variables for fitting and prediction process}
\item{\code{optim_hist}} {Optimization history}
\item{\code{setting}} {Settings for the optimization and fitting process}
}
}
\description{
Fits a latent-variable Gaussian process (LVGP) model to a dataset as described in \code{reference 1}.
    The input variables can be quantitative or qualitative/categorical or mixed.
    The output variable is quantitative and scalar.
}
\examples{
# Math example with 2 quantitative and 1 qualitative variables (dataset included in the package):
#     Fit a model (with default settings) and evaluate the performance
#     by computing the root mean squared error (RMSE) in prediction.
#     Also, plot the latent variable parameters.
X_tr <- math_example$X_tr
Y_tr <- math_example$Y_tr
X_te <- math_example$X_te
Y_te <- math_example$Y_te
n_te <- nrow(X_te)
model <- LVGP_fit(X_tr, Y_tr, ind_qual = c(3))
output <- LVGP_predict(X_te, model)
Y_hat <- output$Y_hat
RRMSE <- sqrt(sum((Y_hat-Y_te)^2)/n_te)/(max(Y_te)-min(Y_te))
LVGP_plot(model)

}
\references{
\enumerate{
\item "A Latent Variable Approach to Gaussian Process Modeling with Qualitative and Quantitative Factors", Yichi Zhang, Siyu Tao, Wei Chen, and Daniel W. Apley (\href{https://arxiv.org/abs/1806.07504}{arXiv})
}
}
\seealso{
\code{\link[stats]{optim}} for the details on \code{L-BFGS-B} algorithm used in optimization.\cr
\code{\link[LVGP]{LVGP_predict}} to use the fitted LVGP model for prediction.\cr
\code{\link[LVGP]{LVGP_plot}} to plot the features of the fitted model.
}
