% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constrain.R
\name{constrain}
\alias{constrain}
\title{Constrain Data to a Specified Range}
\usage{
constrain(x, xrange)
}
\arguments{
\item{x}{A numeric vector of values to constrain.}

\item{xrange}{A numeric vector of length two specifying the constraints, the minimum and
maximum value for \code{x}.}
}
\value{
A numeric vector, the same length as \code{x}, in which the minimum
    constraint is assigned to values of \code{x} less than the minimum,
    and the maximum constraint is assigned to values of \code{x} greater than
    the maximum.
}
\description{
Constrain data to a specified range, assigning values from the specified
  range to those outside the range, typically for graphing purposes.
}
\examples{
constrain(1:20, c(3, 19))
}
