% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stationary_p.R
\name{stationary_p}
\alias{stationary_p}
\title{Compute the periodically stationary distribution of a periodically inhomogeneous Markov chain}
\usage{
stationary_p(Gamma, t = NULL, tol = .Machine$double.eps)
}
\arguments{
\item{Gamma}{Array of transition probability matrices of dimension c(N,N,L).}

\item{t}{Integer index of the time point in the cycle, for which to calculate the stationary distribution
If t is not provided, the function calculates all stationary distributions for each time point in the cycle.}

\item{tol}{The tolerance for detecting linear dependencies in the columns of the thinned transition matrix. The default is .Machine$double.eps.}
}
\value{
Either the periodically stationary distribution at time t or all periodically stationary distributions.
}
\description{
If the transition probability matrix of an inhomogeneous Markov chain varies only periodically (with period length \eqn{L}), it converges to a so-called periodically stationary distribution. 
This happens, because the thinned Markov chain, which has a full cycle as each time step, has homogeneous transition probability matrix \cr\cr
\eqn{\Gamma_t = \Gamma^{(t)} \Gamma^{(t+1)} \dots \Gamma^{(t+L-1)}} for all \eqn{t = 1, \dots, L}. \cr \cr
The stationary distribution for time \eqn{t} satifies \eqn{\delta^{(t)} \Gamma_t = \delta^{(t)}}. \cr
This function calculates the periodically stationary distribution.
}
\examples{
L = 24
beta = matrix(c(-1, 2, -1, -2, 1, -1), nrow = 2, byrow = TRUE)
Gamma = tpm_p(1:L, L, beta, degree = 1)
# Periodically stationary distribution for specific time point
delta = stationary_p(Gamma, 4)

# All periodically stationary distributions
Delta = stationary_p(Gamma)
}
