% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_gaps_perc2.R
\name{calculate_gaps_perc2}
\alias{calculate_gaps_perc2}
\title{Compute the percentile value of each height}
\usage{
calculate_gaps_perc2 (LAD_profiles)
}
\arguments{
\item{LAD_profiles}{original tree Leaf Area Density (LAD) profile (output of [lad.profile()] function in the \emph{leafR} package.
An object of the class text}
}
\value{
A data frame giving the percentile value of each height.
}
\description{
This function calculates the percentile value of each height
}
\examples{
library(magrittr)
library(dplyr)

# LAD profiles derived from normalized ALS data after applying [lad.profile()] function
LAD_profiles <- read.table(system.file("extdata", "LAD_profiles.txt", package = "LadderFuelsR"),
header = TRUE)
LAD_profiles$treeID <- factor(LAD_profiles$treeID)

trees_name1 <- as.character(LAD_profiles$treeID)
trees_name2 <- factor(unique(trees_name1))

percentile_list1<-list()

for (i in levels(trees_name2)) {
tree1 <- LAD_profiles |> dplyr::filter(treeID == i)
percentiles <- calculate_gaps_perc2(tree1)
percentile_list1[[i]] <- percentiles
}
gaps_perc2 <- dplyr::bind_rows(percentile_list1)
gaps_perc2$treeID <- factor(gaps_perc2$treeID)

}
\author{
Olga Viedma, Carlos Silva and JM Moreno
}
