% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbh_metrics.R
\name{get_cbh_metrics}
\alias{get_cbh_metrics}
\title{Methods to estimated the canopy Base Height of a tree: maximum LAD percentage, maximum distance and the last distance}
\usage{
get_cbh_metrics(effective_LAD, verbose=TRUE)
}
\arguments{
\item{effective_LAD}{Tree metrics with gaps (distances), fuel base heights, and depths of fuel layers with LAD percentage greater than a threshold.
(output of [get_layers_lad()] function).
An object of the class text.}

\item{verbose}{Logical, indicating whether to display informational messages (default is TRUE).}
}
\value{
A data frame giving the Canopy Base Height (CBH) of a tree using three criteria: maximum LAD percentage, maximum distance and the last distance.
}
\description{
This function determines the CBH of a segmented tree using three criteria: maximum LAD percentage, maximum distance and the last distance.
}
\details{
List of tree metrics:
\itemize{
  \item treeID: tree ID with strings and numeric values
  \item treeID1: tree ID with only numeric values
  \item dist: Distance between consecutive fuel layers (m)
  \item Hdist: Height of the distance between consecutive fuel layers (m)
  \item Hcbh: Height of the base of each fuel layer (m)
  \item effdist: Effective distance between consecutive fuel layers (m) (> 1 m)
  \item dptf: Depth of fuel layers (m) at distances greater than 1 m
  \item Hdptf: Height of the depth of fuel layers (m) at distances greater than 1 m
  \item maxlad_Hcbh - Height of the CBH of the segmented tree based on the maximum LAD percentage
  \item max_Hcbh - Height of the CBH of the segmented tree based on the maximum distance found in its profile
  \item last_Hcbh - Height of the CBH of the segmented tree based on the last distance found in its profile
  \item maxlad_ - Values of distance and fuel depth and their corresponding heights at the maximum LAD percentage
  \item max_ - Values of distance and fuel depth and their corresponding heights at the maximum distance
  \item last_ - Values of distance and fuel depth and their corresponding heights at the last distance
  \item nlayers - Number of effective fuel layers
  \item max_height - Maximum height of the tree profile
}
}
\examples{
library(magrittr)
library(stringr)
library(dplyr)

# Before running this example, make sure to run get_real_depths().
if (interactive()) {
effective_LAD <- get_layers_lad()
LadderFuelsR::effective_LAD$treeID <- factor(LadderFuelsR::effective_LAD$treeID)

trees_name1 <- as.character(effective_LAD$treeID)
trees_name2 <- factor(unique(trees_name1))

cbh_dist_list <- list()

for (i in levels(trees_name2)) {
tree1 <- effective_LAD |> dplyr::filter(treeID == i)
cbh_dist_metrics <- get_cbh_metrics(tree1, verbose=TRUE)
cbh_dist_list[[i]] <- cbh_dist_metrics
}

# Combine the individual data frames
cbh_metrics <- dplyr::bind_rows(cbh_dist_list)

# Get original column names
original_column_names <- colnames(cbh_metrics)

# Specify prefixes
desired_order <- c("treeID", "Hcbh", "dptf","effdist","dist", "Hdist", "Hdptf", "max_","last_",
"maxlad_", "nlayers")

# Identify unique prefixes
prefixes <- unique(sub("^([a-zA-Z]+).*", "\\\\1", original_column_names))
# Initialize vector to store new order
new_order <- c()

# Loop over desired order of prefixes
for (prefix in desired_order) {
 # Find column names matching the current prefix
matching_columns <- grep(paste0("^", prefix), original_column_names, value = TRUE)
# Append to the new order
new_order <- c(new_order, matching_columns)
}
# Reorder values
cbh_metrics <- cbh_metrics[, new_order]
}
}
\seealso{
\code{\link{get_layers_lad}}
}
\author{
Olga Viedma, Carlos Silva and JM Moreno
}
