% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/test_symmetry.R
\name{test_symmetry}
\alias{test_symmetry}
\title{Test symmetry based on Lambert W heavy tail(s)}
\usage{
test_symmetry(LambertW.fit, method = c("Wald", "LR"))
}
\arguments{
\item{LambertW.fit}{an object of class \code{LambertW_fit} with \code{type = "hh"} or
a numeric vector (observed data). If it is data, then an
asymmetric Lambert W \eqn{\times} Gaussian distribution (\code{distname =
"normal"}) with two tail parameters (\code{"hh"}) will be fit to the data
internally and then used as the new \code{LambertW.fit}.}

\item{method}{test methodology: \code{"Wald"} (default) or a likelihood ratio
\code{"LR"} test}
}
\value{
A list of class \code{"htest"} containing:
\item{statistic}{the value of the test statistic,}
\item{p.value }{the p-value for the test,}
\item{method}{the character string describing the test,}
\item{data.name}{a character string giving the name(s) of the data.}
}
\description{
Performs a test for the null hypothesis of symmetry, \eqn{H_0: \delta_l =
\delta_r}, versus the alternative of asymmetry. This can be done using a Wald
test of the linear restriction \eqn{H_0: \delta_l - \delta_r = 0} or a
likelihood ratio test.

By default it uses \code{"Wald"} test since this only requires the Hessian
of the \code{"hh"} Lambert W fit.  The \code{"LR"} test requires the log-likelihood
values for both MLEs (type \code{"h"} and \code{"hh"}) and thus takes
longer to compute.
}
\examples{
# skewed
yy <- rLambertW(n = 500, theta = list(delta = c(0.1, 0.25), beta = c(2, 1)),
                distname = "normal")
fit.ml <- MLE_LambertW(yy, type = "hh", distname = "normal",
                       hessian = TRUE)
summary(fit.ml)
test_symmetry(fit.ml, "LR")
test_symmetry(fit.ml, "Wald")

\dontrun{
# symmetric
yy <- rLambertW(n = 500, theta = list(delta = c(0.2, 0.2), beta = c(2, 1)),
                distname = "normal")
fit.ml <- MLE_LambertW(yy, type = "hh", distname = "normal")
summary(fit.ml)
test_symmetry(fit.ml, "LR")
test_symmetry(fit.ml, "Wald")
}
}
\keyword{htest}

