% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/LagLaplaceDeconvolution.R
\docType{data}
\name{EX_DCEMRI_t0.rda, EX_DCEMRI_t1.rda}
\alias{AIF,}
\alias{EX_DCEMRI_t0,}
\alias{EX_DCEMRI_t0.rda, EX_DCEMRI_t1.rda}
\alias{EX_DCEMRI_t1,}
\alias{TUM_1,}
\alias{TUM_2,}
\alias{TUM_3,}
\alias{delta,}
\alias{ex_dcemri}
\alias{sigma,}
\alias{times,}
\title{Data from two Dynamical Contrast Enhanced Computer Tomography (DCE-CT) image sequences realized one patient of the cohort REMISCAN before treatment starts (t0) and after 15 days of treatment (t1). These are the real data used to illustrate the paper in References.}
\usage{
data(EX_DCEMRI_t0)
}
\description{
Each dataset contains a variable \code{ex_dcemri} which is a list containing
#' \itemize{
  \item \code{AIF}, numeric vector, the averaged enhancement curve recorded in the aorta, the convolution kernel
  \item \code{TUM_1}, \code{TUM_2}, \code{TUM_3}, numeric vectors, three averaged enhancement curves recorded in homogenous regions in the tumor, the observations
  \item \code{times}, numeric vector, the observation times
  \item \code{sigma}, numeric,  the noise level
  \item \code{delta}, numeric, equals 0, a time shift assumed to be less than 1 time unit
}
}
\author{
C-A. Cuenod and Y. Rozenholc
}
\references{
"Laplace deconvolution on the basis of time domain data and its application to Dynamic Contrast Enhanced imaging" by F. Comte, C-A. Cuenod, M. Pensky, Y. Rozenholc (ArXiv http://arxiv.org/abs/1405.7107)

REMISCAN - Project number IDRCB 2007-A00518-45/P060407/STIC 2006; Research Ethics Board (REB) approved- cohort funding by INCa (1M Euros) and promoted by the AP-HP (Assistance Publique Hôpitaux de Paris). Inclusion target: 100 patients. Start in 2007. Closed since July 2015.
}
\keyword{data}

