% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Translation.R
\name{Translate}
\alias{Translate}
\title{Translates a geometric object}
\usage{
Translate(object, v)
}
\arguments{
\item{object}{geometric object, previously created with function \code{CreatePolygon}}

\item{v}{Vector containing the xy-coordinates of the translation vector}
}
\value{
Returns a polygon whose coordinates are translated according to vector \code{v}
}
\description{
\code{Translate} translates a geometric object of any of the following types: line, polygon or segment
}
\examples{
x_min <- -5
x_max <- 5
y_min <- -5
y_max <- 5
CoordinatePlane(x_min, x_max, y_min, y_max)
P1 <- c(0,0)
P2 <- c(1,1)
P3 <- c(2,0) 
Poly <- CreatePolygon(P1, P2, P3)
Draw(Poly, "blue")
v <- c(1,2)
Poly_translated <- Translate(Poly, v)
Draw(Poly_translated, "orange")
}
