% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PermuTest.R
\name{PermuTest}
\alias{PermuTest}
\alias{class.pmt}
\title{PermuTest Class}
\description{
Abstract class for permutation tests.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{type}}{The way to calculate the p-value.}

\item{\code{method}}{The method used.}

\item{\code{scoring}}{The scoring system used.}

\item{\code{alternative}}{The alternative hypothesis.}

\item{\code{null_value}}{The hypothesized value of the parameter in the null hypothesis.}

\item{\code{conf_level}}{The confidence level of the interval.}

\item{\code{n_permu}}{The number of permutations used.}

\item{\code{data}}{The data.}

\item{\code{statistic}}{The test statistic.}

\item{\code{p_value}}{The p-value.}

\item{\code{estimate}}{The estimated value of the parameter.}

\item{\code{conf_int}}{The confidence interval of the parameter.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PermuTest-test}{\code{PermuTest$test()}}
\item \href{#method-PermuTest-print}{\code{PermuTest$print()}}
\item \href{#method-PermuTest-plot}{\code{PermuTest$plot()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PermuTest-test"></a>}}
\if{latex}{\out{\hypertarget{method-PermuTest-test}{}}}
\subsection{Method \code{test()}}{
Perform test on sample(s).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PermuTest$test(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{sample(s). Can be numeric vector(s) or a \code{data.frame} or \code{list} containing them.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The object itself (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PermuTest-print"></a>}}
\if{latex}{\out{\hypertarget{method-PermuTest-print}{}}}
\subsection{Method \code{print()}}{
Print the results of the test.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PermuTest$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The object itself (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PermuTest-plot"></a>}}
\if{latex}{\out{\hypertarget{method-PermuTest-plot}{}}}
\subsection{Method \code{plot()}}{
Plot histogram(s) of the permutation distribution. Note that this method only works if \code{type} is set to \code{"permu"}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PermuTest$plot(style = c("graphics", "ggplot2"), ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{style}}{a character string specifying which package to use.}

\item{\code{...}}{passed to \code{\link[graphics:hist]{graphics::hist()}} or \code{\link[ggplot2:geom_histogram]{ggplot2::stat_bin()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The object itself (invisibly).
}
}
}
