% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LibOPF.R
\name{opf_check}
\alias{opf_check}
\title{Checks the OPF file for proper formatting purposes}
\usage{
opf_check(file)
}
\arguments{
\item{file}{The text OPF file name}
}
\value{
`NULL`
}
\description{
Checks the OPF file for proper formatting purposes
}
\details{
usage opf_check <input ASCII file in the LibOPF format>:
Note that the input file for opf_check must be a text file.
Use opf2txt to convert your OPF binary file into a text file.
}
\examples{
dataset <- opf_read_subGraph(system.file("extdata/boat.dat",package = "LibOPF"))
File <- file.path(tempdir(), "boat.txt")
opf2txt(dataset,File)
opf_check(File)

}
