% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contractGrid.R
\name{makeContractGridDimname}
\alias{makeContractGridDimname}
\alias{makeContractGridDimnames}
\title{Create human-readable labels for the dimensions in a \code{\link[=contractGrid]{contractGrid()}}}
\usage{
makeContractGridDimname(value)

makeContractGridDimnames(axes)
}
\arguments{
\item{value}{the value along the axis, for which a name should be generated}

\item{axes}{the axes with all names, for which a name should be generated}
}
\value{
The name of the entry in the dimnames of \code{\link[=contractGrid]{contractGrid()}}

an array of dimnames derived from the axes definitions of \code{\link[=contractGrid]{contractGrid()}}
}
\description{
The function \code{makeContractGridDimname} generates a short, human-readable
dimension label for the entries along the axes of a \code{\link[=contractGrid]{contractGrid()}}.
The default is to use the \code{value} unchanged as the row-/columnname, but
for some parameter values (like a \link{InsuranceTarif} or \link{mortalityTable})
a custom method of this function is needed to create the (short) human-readable
representation for the axes in the grid.

The function \code{makeContractGridDimnames} generate proper
dimnames for all entries of the axes of a \code{\link[=contractGrid]{contractGrid()}} by calling
\code{makeContractGridDimname} on each of the axes' values
}
\section{Functions}{
\itemize{
\item \code{makeContractGridDimname()}: Create a short, human-readable dimensional name for an object (default S3 method)

\item \code{makeContractGridDimnames()}: Generate proper dimnames for all entries of the axes of a \code{\link[=contractGrid]{contractGrid()}}

}}
\examples{
library(MortalityTables)
mortalityTables.load("Austria_Census")

makeContractGridDimname(mort.AT.census.2011.unisex)

makeContractGridDimnames(axes = list(
    age = seq(30,60,10),
    mortalityTable = c(mort.AT.census.2011.unisex, mort.AT.census.2011.male,
                       mort.AT.census.2011.female))
)
}
