% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lindley.R
\name{Lindley}
\alias{Lindley}
\alias{dlindley}
\alias{hlindley}
\alias{plindley}
\alias{qlindley}
\alias{rlindley}
\alias{waitingtimes}
\title{One-Parameter Lindley Distribution}
\source{
[d-h-p-q-r]lindley are calculated directly from the definitions. \code{rlindley} uses either a two-component mixture of the gamma distributions or the quantile function.
}
\usage{
dlindley(x, theta, log = FALSE)

plindley(q, theta, lower.tail = TRUE, log.p = FALSE)

qlindley(p, theta, lower.tail = TRUE, log.p = FALSE)

rlindley(n, theta, mixture = TRUE)

hlindley(x, theta, log = FALSE)
}
\arguments{
\item{x, q}{vector of positive quantiles.}

\item{theta}{positive parameter.}

\item{log, log.p}{logical; If TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; If TRUE, (default), \eqn{P(X \leq x)} are returned, otherwise \eqn{P(X > x)}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to be the number required.}

\item{mixture}{logical; If TRUE, (default), random deviates are generated from a two-component mixture of gamma distributions, otherwise from the quantile function.}
}
\value{
\code{dlindley} gives the density, \code{plindley} gives the distribution function, \code{qlindley} gives the quantile function, \code{rlindley} generates random deviates and \code{hlindley} gives the hazard rate function.

Invalid arguments will return an error message.
}
\description{
Density function, distribution function, quantile function, random number generation and hazard rate function for the one-parameter Lindley distribution with parameter theta.
}
\details{
Probability density function
\deqn{f(x\mid \theta )=\frac{\theta ^{2}}{(1+\theta )}(1+x)e^{-\theta x}}

Cumulative distribution function
\deqn{F(x\mid \theta ) =1 - \left(1+ \frac{\theta x}{1+\theta }\right)e^{-\theta x}}

Quantile function
\deqn{Q(p\mid \theta )=-1-\frac{1}{\theta }-\frac{1}{\theta }W_{-1}\left((1+\theta)( p-1)e^{-(1+\theta) }\right)}

Hazard rate function
\deqn{h(x\mid \theta )=\frac{\theta ^{2}}{1+\theta +\theta x}(1+x)}

where \eqn{W_{-1}} denotes the negative branch of the Lambert W function.
}
\examples{
set.seed(1)
x <- rlindley(n = 1000, theta = 1.5, mixture = TRUE)
R <- range(x)
S <- seq(from = R[1], to = R[2], by = 0.1)
plot(S, dlindley(S, theta = 1.5), xlab = 'x', ylab = 'pdf')
hist(x, prob = TRUE, main = '', add = TRUE)

p <- seq(from = 0.1, to = 0.9, by = 0.1)
q <- quantile(x, prob = p)
plindley(q, theta = 1.5, lower.tail = TRUE)
plindley(q, theta = 1.5, lower.tail = FALSE)
qlindley(p, theta = 1.5, lower.tail = TRUE)
qlindley(p, theta = 1.5, lower.tail = FALSE)

## waiting times data (from Ghitany et al., 2008)
data(waitingtimes)
library(fitdistrplus)
fit <- fitdist(waitingtimes, 'lindley', start = list(theta = 0.1))
plot(fit)


}
\author{
Josmar Mazucheli \email{jmazucheli@gmail.com}

Larissa B. Fernandes \email{lbf.estatistica@gmail.com}
}
\references{
Ghitany, M. E., Atieh, B., Nadarajah, S., (2008). Lindley distribution and its application. \emph{Mathematics and Computers in Simulation}, \bold{78}, (4), 49-506.

Jodra, P., (2010). Computer generation of random variables with Lindley or Poisson-Lindley distribution via the Lambert W function. \emph{Mathematics and Computers in Simulation}, \bold{81}, (4), 851-859.

Lindley, D. V., (1958). Fiducial distributions and Bayes' theorem. \emph{Journal of the Royal Statistical Society. Series B. Methodological}, \bold{20}, 102-107.

Lindley, D. V., (1965). \emph{Introduction to Probability and Statistics from a Bayesian View-point, Part II: Inference}. Cambridge University Press, New York.
}
\seealso{
\code{\link[lamW]{lambertWm1}}, \code{\link[LindleyR]{DLindley}}.
}

