#' oat consensus map data frame
#'
#' Chaffin, A. S., Y. Huang, S. Smith, W. A. Bekele, E. Babiker, B. N. Gnanesh,
#' B. J. Foresman, S. G. Blanchard, J. J. Jay, R. W. Reid, C. P. Wight, S. Chao,
#' R. Oliver, E. Islamovic, F. L. Kolb, C. McCartney, J. W. Mitchell Fetch,
#' A. D. Beattie, ?. Bjornstad, J. M. Bonman, T. Langdon, C. J. Howarth,
#' C. R. Brouwer, E. N. Jellen, K. E. Klos, J. A. Poland, T. Hsieh, R. Brown,
#' E. Jackson, J. A. Schlueter, and N. A. Tinker.
#' 2016. A Consensus Map in Cultivated Hexaploid Oat Reveals Conserved Grass
#' Synteny with Substantial Subgenome Rearrangement.
#' Plant Genome 9. doi:10.3835/plantgenome2015.10.0102
#'
#' Contains the following columns:
#'      \enumerate{
#'        \item Group - This will be the title for the linkage
#'              group unless overridden.
#'        \item Position - must be in numerical order ascending within
#'              linkage group name.
#'        \item Locus - marker name at this position.
#'      }
#'
"oat"
#'
#' a carrot comparative linkage map data frame
#' kindly provided by Massimo Iorizzo:
#' Cavagnaro et al. BMC Genomics 2014, 15:1118
#'
#' Contains the following columns:
#'      \enumerate{
#'        \item group - This will be the title for the linkage
#'              group unless overridden.
#'        \item position - must be in numerical order ascending within
#'              linkage group name.
#'        \item locus - marker name at this position.
#'      }
#'
"carrot"
