% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataProcessing.R
\name{groupmsbatch}
\alias{groupmsbatch}
\title{Group features from an msbatch}
\usage{
groupmsbatch(
  msbatch,
  dmz = 5,
  drtagglom = 30,
  drt = 15,
  minsamples,
  minsamplesfrac = 0.25,
  parallel = FALSE,
  ncores
)
}
\arguments{
\item{msbatch}{msbatch obtained from \link{setmsbatch} or \link{alignmsbatch} 
functions.}

\item{dmz}{mass tolerance between peak groups for grouping in ppm.}

\item{drtagglom}{rt window for mz partitioning.}

\item{drt}{rt window for peaks clustering.}

\item{minsamples}{minimum number of samples represented in clusters 
used for grouping.}

\item{minsamplesfrac}{minimum samples fraction represented in each cluster 
used for grouping. Used to calculate minsamples in case it is missing.}

\item{parallel}{logical. If TRUE, parallel processing is performed.}

\item{ncores}{number of cores to be used in case parallel is TRUE.}
}
\value{
grouped msbatch
}
\description{
Group features from an msbatch
}
\examples{
\dontrun{
msbatch <- groupmsbatch(msbatch)
}

}
\author{
M Isabel Alcoriza-Balaguer <maialba@iislafe.es>
}
