% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineplot.R
\name{abundance.lineplot}
\alias{abundance.lineplot}
\title{Plot Abundance Data}
\usage{
abundance.lineplot(
  data,
  group,
  by = data.frame(group = c(), variable.1 = c(), variable.2 = c()),
  summary = "Mean",
  error = "SD",
  .width = 0.5,
  .position_dodge = 0.5,
  errorbar.width = 0.5,
  .xlab = "group",
  .ylab = "abundance",
  sigf = "P-value",
  axis.title.size = 10,
  axis.title.x.vjust = 0,
  axis.title.y.vjust = 0,
  axis.text.size = 10,
  axis.line.size = 0.5,
  axis.tick.length = 0.2,
  legend.title = "",
  legend.color = "Set2",
  .legend.direction = "vertical",
  .legend.position = "right",
  main.size = 10
)
}
\arguments{
\item{data}{The data frame containing abundance data.}

\item{group}{A data frame containing grouping information.}

\item{by}{A data frame specifying additional variables for grouping and plotting (default is an empty data frame).}

\item{summary}{The method to summarise data, containing "Mean" and "Median". The default value is "Mean".}

\item{error}{The method to calculate errors, containing "SD" and "SE". The default value is "SD".}

\item{.width}{The width of lines in the plot (default is 0.5).}

\item{.position_dodge}{The position adjustment parameter for dodging lines (default is 0.5).}

\item{errorbar.width}{The width of error bars (default is 0.5).}

\item{.xlab}{The label for the x-axis (default is 'group').}

\item{.ylab}{The label for the y-axis (default is 'abundance').}

\item{sigf}{The type of significance in plots, can be "No Signal", "Star" or "P-value". The default value is "P-value".}

\item{axis.title.size}{The size of axis title text (default is 10).}

\item{axis.title.x.vjust}{The vertical adjustment parameter for x-axis title (default is 0).}

\item{axis.title.y.vjust}{The vertical adjustment parameter for y-axis title (default is 0).}

\item{axis.text.size}{The size of axis text (default is 10).}

\item{axis.line.size}{The size of axis lines (default is 0.5).}

\item{axis.tick.length}{The length of axis ticks (default is 0.2).}

\item{legend.title}{The title for the legend (default is an empty string).}

\item{legend.color}{The color palette for the legend (default is a set of predefined colors).}

\item{.legend.direction}{The direction of the legend ('horizontal' or 'vertical', default is 'vertical').}

\item{.legend.position}{The position of the legend ('top', 'bottom', 'left', 'right', or NULL, default is 'right').}

\item{main.size}{The size of plot titles (default is 10).}
}
\value{
A list of ggplot objects, each representing a line plot for abundance data of a species.
}
\description{
This function generates bar plots for abundance data.
}
