% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localControl.R
\name{localControlCompetingRisks}
\alias{localControlCompetingRisks}
\title{Local Control Competing Risks}
\usage{
localControlCompetingRisks(data, outcomeColName, timeColName, treatmentColName,
  clusterVars, cenCode = 0, treatmentCode = "", labelColName = "",
  radStepType = "exp", radDecayRate = 0.8, radMinFract = 0.01,
  radiusLevels = numeric(), normalize = TRUE, verbose = FALSE,
  numThreads = 1)
}
\arguments{
\item{data}{DataFrame containing all variables which will be used for the analysis.}

\item{outcomeColName}{A string containing the name of a column in data.
The column contains the outcome variable to be compared between the treatment groups.}

\item{timeColName}{A string containing the name of a column in data.
The column contains the time to outcome for each of the observations in data.}

\item{treatmentColName}{A string containing the name of a column in data.
The column contains the treatment variable specifying the treatment groups.}

\item{clusterVars}{A character vector containing column names in data.
Each column contains an X-variable, or covariate which will be used to form patient clusters.}

\item{cenCode}{A value specifying which of the outcome values corresponds to a censored observation.}

\item{treatmentCode}{(optional) A string containing one of the factor levels from the treatment column.
If provided, the corresponding treatment will be considered "Treatment 1".
Otherwise, the value in the first row of the column will be considered the primary treatment.}

\item{labelColName}{(optional) A string containing the name of a column from data.
The column contains labels for each of the observations in data, defaults to the row indices.}

\item{radStepType}{(optional) Used in the generation of correction radii.
The step type used to generate each correction radius after the maximum.
Currently accepts "unif" and "exp" (default).
"unif" for uniform decay ex: (radDecayRate = 0.1) (1, 0.9, 0.8, 0.7, ..., ~minRadFract, 0)
"exp" for exponential decay ex: (radDecayRate = 0.9) (1, 0.9, 0.81, 0.729, ..., ~minRadFract, 0)}

\item{radDecayRate}{(optional) Used in the generation of correction radii.
The size of the "step" between each of the generated correction radii.
If radStepType == "exp", radDecayRate must be a value between (0,1).
This value defaults to 0.8.}

\item{radMinFract}{(optional) Used in the generation of correction radii.
A floating point number representing the smallest fraction of the maximum radius to use as a correction radius.}

\item{radiusLevels}{(optional) Advanced users only. By default, Local Control builds a set of radii to fit data. 
The radiusLevels parameter allows users to override the construction by explicitly providing a set of radii.}

\item{normalize}{(optional) Logical value. Tells local control if it should or should not normalize the covariates. Default is TRUE.}

\item{verbose}{(optional) Logical value. Display or suppress the console output during the call to Local Control. Default is FALSE.}

\item{numThreads}{(optional) An integer value specifying the number of threads which will be assigned to the analysis.
The maximum number of threads varies depending on the system hardware. Defaults to 1 thread.}
}
\value{
A list containing the results from the call to localControlCompetingRisks.
}
\description{
This is the survival and competing risks implementation of Local Control.
This function provides support for the analysis of survival and competing risks data.
}
\examples{
 data(cardSim)
 results = localControlCompetingRisks(data = cardSim, 
                                      outcomeColName = "status", 
                                      timeColName = "time", 
                                      treatmentColName = "drug", 
                                      treatmentCode = 1,
                                      clusterVars = c("age", "bmi"))
 plotLocalControlCIF(results)
  
}
\references{
\itemize{
   \item Fischer K, Gartner B, Kutz M. Fast Smallest-Enclosing-Ball Computation in High Dimensions. In: Algorithms - ESA 2003. Springer, Berlin, Heidelberg; 2003:630-641.
   \item Martin Kutz, Kaspar Fischer, Bernd Gartner. miniball-1.0.3. \url{https://github.com/hbf/miniball}.
}
}
