% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusteringLC.R
\name{SPSnbins}
\alias{SPSnbins}
\title{Change the Number of Bins in Supervised Propensiy Scoring}
\usage{
SPSnbins(envir, dframe, prnk, qbin, bins = 8)
}
\arguments{
\item{envir}{name of the working local control classic environment.}

\item{dframe}{{Name of data.frame of the form output by SPSlogit().}}

\item{prnk}{{Name of PS tied-rank variable from previous call to SPSlogit().}}

\item{qbin}{{Name of variable to contain the re-assigned bin number for each patient.}}

\item{bins}{{Number of PS bins desired.}}
}
\value{
An output data.frame with new variables inserted:
\itemize{
  \item{dframe2}{Modified version of the data.frame specified as the first argument to SPSnbins().}
}
}
\description{
{Change the Number of Bins in Supervised Propensiy Scoring}
}
\details{
Part or all of the first phase of Supervised Propensity Scoring will need to be redone
  if SPSbalan() detects dependence of within-bin X-covariate distributions upon treatment choice.
  Use SPSnbins() to change (increase) the number of adjacent PS bins.  If this does not achieve
  balance, invoke SPSlogit() again to modify the form of your PS logistic model, typically by
  adding interaction and/or curvature terms in continuous X-covariates.
}
\references{
{
  Cochran WG. (1968) The effectiveness of adjustment by subclassification
  in removing bias in observational studies. \emph{Biometrics} \bold{24}:
  205-213.

  Obenchain RL. (2011) \bold{USPSinR.pdf}  USPS R-package vignette, 40 pages.

  Rosenbaum PR, Rubin DB. (1984) Reducing Bias in Observational Studies
  Using Subclassification on a Propensity Score. \emph{J Amer Stat Assoc}
  \bold{79}: 516-524.
}
}
\seealso{
\code{\link{SPSlogit}}, \code{\link{SPSbalan}} and \code{\link{SPSoutco}}.
}
\author{
Bob Obenchain <wizbob@att.net>
}
\keyword{design}
